/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.apache.camel.xml.jaxb.JaxbHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JdkService(value="modelxml-dumper")
public class JaxbModelToXMLDumper
implements ModelToXMLDumper {
    public String dumpModelAsXml(CamelContext context, NamedNode definition) throws Exception {
        return this.doDumpModelAsXml(context, definition, true);
    }

    public String doDumpModelAsXml(CamelContext context, NamedNode definition, boolean generatedIds) throws Exception {
        Document dom;
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        HashMap<String, KeyValueHolder<Integer, String>> locations = new HashMap<String, KeyValueHolder<Integer, String>>();
        if (definition instanceof RouteTemplatesDefinition) {
            RouteTemplatesDefinition routeTemplatesDefinition = (RouteTemplatesDefinition)definition;
            List templates = routeTemplatesDefinition.getRouteTemplates();
            for (Object route : templates) {
                JaxbHelper.extractNamespaces(route.getRoute(), namespaces);
                if (context.isDebugging().booleanValue()) {
                    JaxbHelper.extractSourceLocations(route.getRoute(), locations);
                }
                JaxbHelper.resolveEndpointDslUris(route.getRoute());
            }
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template = (RouteTemplateDefinition)definition;
            JaxbHelper.extractNamespaces(template.getRoute(), namespaces);
            if (context.isDebugging().booleanValue()) {
                JaxbHelper.extractSourceLocations(template.getRoute(), locations);
            }
            JaxbHelper.resolveEndpointDslUris(template.getRoute());
        } else if (definition instanceof RoutesDefinition) {
            RoutesDefinition routesDefinition = (RoutesDefinition)definition;
            List routes = routesDefinition.getRoutes();
            for (Object route : routes) {
                JaxbHelper.extractNamespaces((RouteDefinition)route, namespaces);
                if (context.isDebugging().booleanValue()) {
                    JaxbHelper.extractSourceLocations((RouteDefinition)route, locations);
                }
                JaxbHelper.resolveEndpointDslUris((RouteDefinition)route);
            }
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)definition;
            JaxbHelper.extractNamespaces(route, namespaces);
            if (context.isDebugging().booleanValue()) {
                JaxbHelper.extractSourceLocations(route, locations);
            }
            JaxbHelper.resolveEndpointDslUris(route);
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        String xml = buffer.toString();
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        if (context.isDebugging().booleanValue()) {
            JaxbHelper.enrichLocations(dom, locations);
        }
        JaxbModelToXMLDumper.sanitizeXml(dom, generatedIds);
        Element documentElement = dom.getDocumentElement();
        for (Map.Entry entry : namespaces.entrySet()) {
            String nsPrefix = (String)entry.getKey();
            Object prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
            documentElement.setAttribute((String)prefix, (String)entry.getValue());
        }
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        outputProperties.put("encoding", "UTF-8");
        try {
            return xmlConverter.toStringFromDocument(dom, outputProperties);
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException("Failed converting document object to string", transformerException);
        }
    }

    public String dumpModelAsXml(final CamelContext context, final NamedNode definition, boolean resolvePlaceholders, boolean generatedIds) throws Exception {
        String xml = this.doDumpModelAsXml(context, definition, generatedIds);
        if (resolvePlaceholders) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String transform(String text) {
                    boolean updated;
                    String after = text;
                    PropertiesComponent pc = context.getPropertiesComponent();
                    Properties prop = new Properties();
                    Iterator it = null;
                    if (definition instanceof RouteDefinition) {
                        it = ObjectHelper.createIterator((Object)definition);
                    } else if (definition instanceof RoutesDefinition) {
                        RoutesDefinition routesDefinition = (RoutesDefinition)definition;
                        it = ObjectHelper.createIterator((Object)routesDefinition.getRoutes());
                    }
                    while (it != null && it.hasNext()) {
                        RouteDefinition routeDefinition = (RouteDefinition)it.next();
                        if (routeDefinition.isTemplate() == null || !routeDefinition.isTemplate().booleanValue() || routeDefinition.getTemplateParameters() == null) continue;
                        prop.putAll((Map<?, ?>)routeDefinition.getTemplateParameters());
                    }
                    pc.setLocalProperties(prop);
                    try {
                        after = context.resolvePropertyPlaceholders(after);
                    }
                    catch (Exception routeDefinition) {
                    }
                    finally {
                        pc.setLocalProperties(null);
                    }
                    boolean bl = updated = !text.equals(after);
                    if (updated && !changed.get()) {
                        changed.set(true);
                    }
                    return after;
                }
            });
            if (changed.get()) {
                xml = (String)context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                NamedNode copy = JaxbHelper.modelToXml(context, xml, NamedNode.class);
                xml = PluginHelper.getModelToXMLDumper((CamelContext)context).dumpModelAsXml(context, copy, false, generatedIds);
            }
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpBeansAsXml(CamelContext context, List<Object> beans) throws Exception {
        StringWriter buffer = new StringWriter();
        BeanModelWriter writer = new BeanModelWriter(buffer);
        ArrayList list = new ArrayList();
        for (Object bean : beans) {
            if (!(bean instanceof BeanFactoryDefinition)) continue;
            BeanFactoryDefinition rb = (BeanFactoryDefinition)bean;
            list.add(rb);
        }
        writer.setCamelContext(context);
        writer.start();
        try {
            writer.writeBeans(list);
        }
        finally {
            writer.stop();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpDataFormatsAsXml(CamelContext context, Map<String, Object> dataFormats) throws Exception {
        StringWriter buffer = new StringWriter();
        buffer.write("\n");
        DataFormatModelWriter writer = new DataFormatModelWriter(buffer);
        LinkedHashMap<String, DataFormatDefinition> map = new LinkedHashMap<String, DataFormatDefinition>();
        for (Map.Entry<String, Object> entry : dataFormats.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof DataFormatDefinition)) continue;
            DataFormatDefinition def = (DataFormatDefinition)object;
            map.put(entry.getKey(), def);
        }
        writer.setCamelContext(context);
        writer.start();
        try {
            writer.writeDataFormats(map);
        }
        finally {
            writer.stop();
        }
        return buffer.toString();
    }

    private static void sanitizeXml(Node node, boolean generatedIds) {
        if (node.hasAttributes()) {
            Node attId;
            boolean custom;
            Node att = node.getAttributes().getNamedItem("customId");
            boolean bl = custom = att != null && "true".equals(att.getNodeValue());
            if (att != null) {
                node.getAttributes().removeNamedItem("customId");
            }
            if (!generatedIds && !custom && (attId = node.getAttributes().getNamedItem("id")) != null) {
                node.getAttributes().removeNamedItem("id");
            }
        }
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                JaxbModelToXMLDumper.sanitizeXml(child, generatedIds);
            }
        }
    }

    private static class BeanModelWriter
    implements CamelContextAware {
        private final StringWriter buffer;
        private CamelContext camelContext;

        public BeanModelWriter(StringWriter buffer) {
            this.buffer = buffer;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void start() {
        }

        public void stop() {
        }

        public void writeBeans(List<BeanFactoryDefinition<?>> beans) {
            if (beans.isEmpty()) {
                return;
            }
            for (BeanFactoryDefinition<?> b : beans) {
                this.doWriteBeanFactoryDefinition(b);
            }
        }

        private void doWriteBeanFactoryDefinition(BeanFactoryDefinition<?> b) {
            String type = b.getType();
            if (type.startsWith("#class:")) {
                type = type.substring(7);
            }
            this.buffer.write(String.format("    <bean name=\"%s\" type=\"%s\"", b.getName(), type));
            if (b.getFactoryBean() != null) {
                this.buffer.write(String.format(" factoryBean=\"%s\"", b.getFactoryBean()));
            }
            if (b.getFactoryMethod() != null) {
                this.buffer.write(String.format(" factoryMethod=\"%s\"", b.getFactoryMethod()));
            }
            if (b.getBuilderClass() != null) {
                this.buffer.write(String.format(" builderClass=\"%s\"", b.getBuilderClass()));
            }
            if (b.getBuilderMethod() != null) {
                this.buffer.write(String.format(" builderMethod=\"%s\"", b.getBuilderMethod()));
            }
            if (b.getInitMethod() != null) {
                this.buffer.write(String.format(" initMethod=\"%s\"", b.getInitMethod()));
            }
            if (b.getDestroyMethod() != null) {
                this.buffer.write(String.format(" destroyMethod=\"%s\"", b.getDestroyMethod()));
            }
            if (b.getScriptLanguage() != null) {
                this.buffer.write(String.format(" scriptLanguage=\"%s\"", b.getScriptLanguage()));
            }
            if (b.getScript() != null) {
                this.buffer.write(String.format("        <script>%n", new Object[0]));
                this.buffer.write(b.getScript());
                this.buffer.write("\n");
                this.buffer.write(String.format("        </script>%n", new Object[0]));
            }
            this.buffer.write(">\n");
            if (b.getConstructors() != null && !b.getConstructors().isEmpty()) {
                this.buffer.write(String.format("        <constructors>%n", new Object[0]));
                b.getConstructors().forEach((idx, value) -> {
                    if (idx != null) {
                        this.buffer.write(String.format("            <constructor index=\"%d\" value=\"%s\"/>%n", idx, value));
                    } else {
                        this.buffer.write(String.format("            <constructor value=\"%s\"/>%n", value));
                    }
                });
                this.buffer.write(String.format("        </constructors>%n", new Object[0]));
            }
            if (b.getProperties() != null && !b.getProperties().isEmpty()) {
                this.buffer.write(String.format("        <properties>%n", new Object[0]));
                b.getProperties().forEach((key, value) -> this.buffer.write(String.format("            <property key=\"%s\" value=\"%s\"/>%n", key, value)));
                this.buffer.write(String.format("        </properties>%n", new Object[0]));
            }
            this.buffer.write(String.format("    </bean>%n", new Object[0]));
        }
    }

    private static class DataFormatModelWriter
    implements CamelContextAware {
        private final StringWriter buffer;
        private CamelContext camelContext;

        public DataFormatModelWriter(StringWriter buffer) {
            this.buffer = buffer;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void start() {
        }

        public void stop() {
        }

        public void writeDataFormats(Map<String, DataFormatDefinition> dataFormats) throws Exception {
            if (dataFormats.isEmpty()) {
                return;
            }
            DataFormatsDefinition def = new DataFormatsDefinition();
            def.setDataFormats(new ArrayList<DataFormatDefinition>(dataFormats.values()));
            JAXBContext jaxbContext = JaxbHelper.getJAXBContext(this.camelContext);
            StringWriter tmp = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)def, (Writer)tmp);
            String xml = tmp.toString();
            xml = xml.replace("<dataFormats xmlns=\"http://camel.apache.org/schema/spring\">", "<dataFormats>");
            xml = StringHelper.after((String)xml, (String)"<dataFormats>");
            this.buffer.write("    <dataFormats>");
            for (String line : xml.split("\n")) {
                this.buffer.write("    ");
                this.buffer.write(line);
                this.buffer.write("\n");
            }
        }
    }
}

