/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactHashIterator;

final class HeapCompactSketch
extends CompactThetaSketch {
    private final long thetaLong_;
    private final int curCount_;
    private final int preLongs_;
    private final short seedHash_;
    private final boolean empty_;
    private final boolean ordered_;
    private final boolean singleItem_;
    private final long[] cache_;

    HeapCompactSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, boolean ordered) {
        this.seedHash_ = seedHash;
        this.curCount_ = curCount;
        this.empty_ = empty;
        this.ordered_ = ordered;
        this.cache_ = cache;
        this.thetaLong_ = CompactOperations.correctThetaOnCompact(empty, curCount, thetaLong);
        this.preLongs_ = CompactOperations.computeCompactPreLongs(empty, curCount, thetaLong);
        this.singleItem_ = CompactOperations.isSingleItem(empty, curCount, thetaLong);
        CompactOperations.checkIllegalCurCountAndEmpty(empty, curCount);
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstSeg) {
        if (!(dstSeg != null || dstOrdered && this.ordered_ != dstOrdered)) {
            return this;
        }
        return CompactOperations.componentsToCompact(this.getThetaLong(), this.getRetainedEntries(true), this.getSeedHash(), this.isEmpty(), true, this.ordered_, dstOrdered, dstSeg, (long[])this.getCache().clone());
    }

    @Override
    public int getCurrentBytes() {
        return this.preLongs_ + this.curCount_ << 3;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered_;
    }

    @Override
    public HashIterator iterator() {
        return new HeapCompactHashIterator(this.cache_);
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    int getCompactPreambleLongs() {
        return this.preLongs_;
    }

    @Override
    int getCurrentPreambleLongs() {
        return this.preLongs_;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    public byte[] toByteArray() {
        int bytes = this.getCurrentBytes();
        byte[] byteArray = new byte[bytes];
        MemorySegment dstSeg = MemorySegment.ofArray(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        int orderedBit = this.ordered_ ? 16 : 0;
        int singleItemBit = this.singleItem_ ? 32 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | orderedBit | singleItemBit);
        int preLongs = this.getCompactPreambleLongs();
        CompactOperations.loadCompactMemorySegment(this.getCache(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstSeg, flags, preLongs);
        return byteArray;
    }
}

