/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import org.apache.polaris.core.persistence.pagination.ImmutablePageToken;
import org.apache.polaris.core.persistence.pagination.PageTokenUtil;
import org.apache.polaris.core.persistence.pagination.Token;
import org.apache.polaris.immutables.PolarisImmutable;

@JsonSerialize(as=ImmutablePageToken.class)
@JsonDeserialize(as=ImmutablePageToken.class)
@PolarisImmutable
public interface PageToken {
    @JsonProperty(value="p")
    public OptionalInt pageSize();

    default public boolean paginationRequested() {
        return this.pageSize().isPresent();
    }

    @JsonProperty(value="v")
    public Optional<Token> value();

    default public <T extends Token> Optional<T> valueAs(Class<T> type) {
        return this.value().flatMap(t -> type.isAssignableFrom(t.getClass()) ? Optional.of((Token)type.cast(t)) : Optional.empty());
    }

    public static PageToken readEverything() {
        return PageTokenUtil.READ_EVERYTHING;
    }

    public static PageToken fromLimit(int limit) {
        return PageTokenUtil.fromLimit(limit);
    }

    public static PageToken build(@Nullable String serializedPageToken, @Nullable Integer requestedPageSize, BooleanSupplier shouldDecodeToken) {
        return PageTokenUtil.decodePageRequest(serializedPageToken, requestedPageSize, shouldDecodeToken);
    }
}

