/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.pagination.EntityIdToken;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.transactional.AbstractTransactionalPersistence;
import org.apache.polaris.core.persistence.transactional.TreeMapMetaStore;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.StorageLocation;

public class TreeMapTransactionalPersistenceImpl
extends AbstractTransactionalPersistence {
    private final TreeMapMetaStore store;
    private final PolarisStorageIntegrationProvider storageIntegrationProvider;
    private final PrincipalSecretsGenerator secretsGenerator;

    public TreeMapTransactionalPersistenceImpl(@Nonnull PolarisDiagnostics diagnostics, @Nonnull TreeMapMetaStore store, @Nonnull PolarisStorageIntegrationProvider storageIntegrationProvider, @Nonnull PrincipalSecretsGenerator secretsGenerator) {
        super(diagnostics);
        this.store = store;
        this.storageIntegrationProvider = storageIntegrationProvider;
        this.secretsGenerator = secretsGenerator;
    }

    @Override
    public <T> T runInTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Supplier<T> transactionCode) {
        return this.store.runInTransaction(this.getDiagnostics(), transactionCode);
    }

    @Override
    public void runActionInTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Runnable transactionCode) {
        this.store.runActionInTransaction(this.getDiagnostics(), transactionCode);
    }

    @Override
    public <T> T runInReadTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Supplier<T> transactionCode) {
        return this.store.runInReadTransaction(this.getDiagnostics(), transactionCode);
    }

    @Override
    public void runActionInReadTransaction(@Nonnull PolarisCallContext callCtx, @Nonnull Runnable transactionCode) {
        this.store.runActionInReadTransaction(this.getDiagnostics(), transactionCode);
    }

    @Override
    public long generateNewIdInCurrentTxn(@Nonnull PolarisCallContext callCtx) {
        return this.store.getNextSequence();
    }

    @Override
    public void writeToEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.getSliceEntities().write(entity);
    }

    @Override
    public <T extends PolarisStorageConfigurationInfo> void persistStorageIntegrationIfNeededInCurrentTxn(@Nonnull PolarisCallContext callContext, @Nonnull PolarisBaseEntity entity, @Nullable PolarisStorageIntegration<T> storageIntegration) {
    }

    @Override
    public void writeToEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.getSliceEntitiesActive().write(entity);
    }

    @Override
    public void writeToEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        this.store.getSliceEntitiesChangeTracking().write(entity);
    }

    @Override
    public void writeToGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.store.getSliceGrantRecords().write(grantRec);
        this.store.getSliceGrantRecordsByGrantee().write(grantRec);
    }

    @Override
    public void deleteFromEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.getSliceEntities().delete(this.store.buildEntitiesKey(entity));
    }

    @Override
    public void deleteFromEntitiesActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.getSliceEntitiesActive().delete(this.store.buildEntitiesActiveKey(entity));
    }

    @Override
    public void deleteFromEntitiesChangeTrackingInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity) {
        this.store.getSliceEntitiesChangeTracking().delete(this.store.buildEntitiesKey(entity));
    }

    @Override
    public void deleteFromGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        this.store.getSliceGrantRecords().delete(grantRec);
        this.store.getSliceGrantRecordsByGrantee().delete(grantRec);
    }

    @Override
    public void deleteAllEntityGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity, @Nonnull List<PolarisGrantRecord> grantsOnGrantee, @Nonnull List<PolarisGrantRecord> grantsOnSecurable) {
        String prefix = this.store.buildPrefixKeyComposite(entity.getCatalogId(), entity.getId());
        this.store.getSliceGrantRecords().deleteRange(prefix);
        this.store.getSliceGrantRecordsByGrantee().deleteRange(prefix);
        grantsOnGrantee.forEach(gr -> this.store.getSliceGrantRecords().delete((PolarisGrantRecord)gr));
        grantsOnSecurable.forEach(gr -> this.store.getSliceGrantRecordsByGrantee().delete((PolarisGrantRecord)gr));
    }

    @Override
    public void deleteAllInCurrentTxn(@Nonnull PolarisCallContext callCtx) {
        this.store.deleteAll();
    }

    @Override
    @Nullable
    public PolarisBaseEntity lookupEntityInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, int typeCode) {
        PolarisBaseEntity entity = this.store.getSliceEntities().read(this.store.buildKeyComposite(catalogId, entityId));
        if (entity != null && entity.getTypeCode() != typeCode) {
            return null;
        }
        return entity;
    }

    @Override
    @Nonnull
    public List<PolarisBaseEntity> lookupEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        return entityIds.stream().map(id -> this.store.getSliceEntities().read(this.store.buildKeyComposite(id.getCatalogId(), id.getId()))).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersionsInCurrentTxn(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        return entityIds.stream().map(id -> this.store.getSliceEntitiesChangeTracking().read(this.store.buildKeyComposite(id.getCatalogId(), id.getId()))).map(entity -> entity != null ? new PolarisChangeTrackingVersions(entity.getEntityVersion(), entity.getGrantRecordsVersion()) : null).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public EntityNameLookupRecord lookupEntityActiveInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntitiesActiveKey entityActiveKey) {
        PolarisBaseEntity entity = this.store.getSliceEntitiesActive().read(this.store.buildKeyComposite(entityActiveKey.getCatalogId(), entityActiveKey.getParentId(), entityActiveKey.getTypeCode(), entityActiveKey.getName()));
        return entity == null ? null : new EntityNameLookupRecord(entity);
    }

    @Override
    @Nonnull
    public List<EntityNameLookupRecord> lookupEntityActiveBatchInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntitiesActiveKey> entityActiveKeys) {
        return entityActiveKeys.stream().map(entityActiveKey -> this.lookupEntityActiveInCurrentTxn(callCtx, (PolarisEntitiesActiveKey)entityActiveKey)).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public <T> Page<T> loadEntitiesInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull Predicate<PolarisBaseEntity> entityFilter, @Nonnull Function<PolarisBaseEntity, T> transformer, @Nonnull PageToken pageToken) {
        Stream<PolarisBaseEntity> data = this.store.getSliceEntitiesActive().readRange(this.store.buildPrefixKeyComposite(catalogId, parentId, entityType.getCode())).stream().map(nameRecord -> this.lookupEntityInCurrentTxn(callCtx, catalogId, nameRecord.getId(), entityType.getCode()));
        Predicate<PolarisBaseEntity> tokenFilter = pageToken.valueAs(EntityIdToken.class).map(entityIdToken -> {
            long nextId = entityIdToken.entityId();
            return e -> e.getId() > nextId;
        }).orElse(e -> true);
        data = data.sorted(Comparator.comparingLong(PolarisEntityCore::getId)).filter(tokenFilter);
        if (entitySubType != PolarisEntitySubType.ANY_SUBTYPE) {
            data = data.filter(e -> e.getSubTypeCode() == entitySubType.getCode());
        }
        data = data.filter(entityFilter);
        return Page.mapped(pageToken, data, transformer, EntityIdToken::fromEntity);
    }

    @Override
    public boolean hasChildrenInCurrentTxn(@Nonnull PolarisCallContext callContext, @Nullable PolarisEntityType entityType, long catalogId, long parentId) {
        String prefixKey = entityType == null ? this.store.buildPrefixKeyComposite(catalogId, parentId) : this.store.buildPrefixKeyComposite(catalogId, parentId, entityType.getCode());
        return !this.store.getSliceEntitiesActive().readRange(prefixKey).isEmpty();
    }

    @Override
    public int lookupEntityGrantRecordsVersionInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId) {
        PolarisBaseEntity entity = this.store.getSliceEntitiesChangeTracking().read(this.store.buildKeyComposite(catalogId, entityId));
        return entity == null ? 0 : entity.getGrantRecordsVersion();
    }

    @Override
    @Nullable
    public PolarisGrantRecord lookupGrantRecordInCurrentTxn(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId, long granteeCatalogId, long granteeId, int privilegeCode) {
        return this.store.getSliceGrantRecords().read(this.store.buildKeyComposite(securableCatalogId, securableId, granteeCatalogId, granteeId, privilegeCode));
    }

    @Override
    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurableInCurrentTxn(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        return this.store.getSliceGrantRecords().readRange(this.store.buildPrefixKeyComposite(securableCatalogId, securableId));
    }

    @Override
    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGranteeInCurrentTxn(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        return this.store.getSliceGrantRecordsByGrantee().readRange(this.store.buildPrefixKeyComposite(granteeCatalogId, granteeId));
    }

    @Override
    @Nullable
    public PolarisPrincipalSecrets loadPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        return this.store.getSlicePrincipalSecrets().read(clientId);
    }

    @Override
    @Nonnull
    public PolarisPrincipalSecrets generateNewPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String principalName, long principalId) {
        PolarisPrincipalSecrets principalSecrets;
        PolarisPrincipalSecrets lookupPrincipalSecrets;
        do {
            principalSecrets = this.secretsGenerator.produceSecrets(principalName, principalId);
        } while ((lookupPrincipalSecrets = this.store.getSlicePrincipalSecrets().read(principalSecrets.getPrincipalClientId())) != null);
        this.store.getSlicePrincipalSecrets().write(principalSecrets);
        return principalSecrets;
    }

    @Override
    @Nonnull
    public PolarisPrincipalSecrets rotatePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        PolarisPrincipalSecrets principalSecrets = this.store.getSlicePrincipalSecrets().read(clientId);
        this.getDiagnostics().checkNotNull(principalSecrets, "cannot_find_secrets", "client_id={} principalId={}", clientId, principalId);
        this.getDiagnostics().check(principalId == principalSecrets.getPrincipalId(), "principal_id_mismatch", "expectedId={} id={}", principalId, principalSecrets.getPrincipalId());
        principalSecrets.rotateSecrets(oldSecretHash);
        if (reset) {
            principalSecrets.rotateSecrets(principalSecrets.getMainSecretHash());
        }
        this.store.getSlicePrincipalSecrets().write(principalSecrets);
        return principalSecrets;
    }

    @Override
    @Nonnull
    public PolarisPrincipalSecrets storePrincipalSecrets(@Nonnull PolarisCallContext callCtx, long principalId, @Nonnull String resolvedClientId, String customClientSecret) {
        PolarisPrincipalSecrets principalSecrets = new PolarisPrincipalSecrets(principalId, resolvedClientId, customClientSecret);
        this.store.getSlicePrincipalSecrets().write(principalSecrets);
        return principalSecrets;
    }

    @Override
    public void deletePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        PolarisPrincipalSecrets principalSecrets = this.store.getSlicePrincipalSecrets().read(clientId);
        this.getDiagnostics().checkNotNull(principalSecrets, "cannot_find_secrets", "client_id={} principalId={}", clientId, principalId);
        this.getDiagnostics().check(principalId == principalSecrets.getPrincipalId(), "principal_id_mismatch", "expectedId={} id={}", principalId, principalSecrets.getPrincipalId());
        this.store.getSlicePrincipalSecrets().delete(clientId);
    }

    @Override
    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> createStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(polarisStorageConfigurationInfo);
    }

    @Override
    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> loadPolarisStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        PolarisStorageConfigurationInfo storageConfig = BaseMetaStoreManager.extractStorageConfiguration(this.getDiagnostics(), entity);
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(storageConfig);
    }

    @Override
    public void rollback() {
        this.store.rollback();
    }

    @Override
    public void writeToPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.store.getSlicePolicyMappingRecords().write(record);
        this.store.getSlicePolicyMappingRecordsByPolicy().write(record);
    }

    @Override
    public void deleteFromPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        this.store.getSlicePolicyMappingRecords().delete(record);
        this.store.getSlicePolicyMappingRecordsByPolicy().delete(record);
    }

    @Override
    public void deleteAllEntityPolicyMappingRecordsInCurrentTxn(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nonnull List<PolarisPolicyMappingRecord> mappingOnTarget, @Nonnull List<PolarisPolicyMappingRecord> mappingOnPolicy) {
        if (entity.getType() == PolarisEntityType.POLICY) {
            PolicyEntity policyEntity = PolicyEntity.of(entity);
            this.store.getSlicePolicyMappingRecordsByPolicy().deleteRange(this.store.buildPrefixKeyComposite(policyEntity.getPolicyTypeCode(), policyEntity.getCatalogId(), policyEntity.getId()));
            mappingOnPolicy.forEach(record -> this.store.getSlicePolicyMappingRecords().delete((PolarisPolicyMappingRecord)record));
        } else {
            this.store.getSlicePolicyMappingRecords().deleteRange(this.store.buildPrefixKeyComposite(entity.getCatalogId(), entity.getId()));
            mappingOnTarget.forEach(record -> this.store.getSlicePolicyMappingRecordsByPolicy().delete((PolarisPolicyMappingRecord)record));
        }
    }

    @Override
    @Nullable
    public PolarisPolicyMappingRecord lookupPolicyMappingRecordInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode, long policyCatalogId, long policyId) {
        return this.store.getSlicePolicyMappingRecords().read(this.store.buildKeyComposite(targetCatalogId, targetId, policyTypeCode, policyCatalogId, policyId));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadPoliciesOnTargetByTypeInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode) {
        return this.store.getSlicePolicyMappingRecords().readRange(this.store.buildPrefixKeyComposite(targetCatalogId, targetId, policyTypeCode));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllPoliciesOnTargetInCurrentTxn(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId) {
        return this.store.getSlicePolicyMappingRecords().readRange(this.store.buildPrefixKeyComposite(targetCatalogId, targetId));
    }

    @Override
    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllTargetsOnPolicyInCurrentTxn(@Nonnull PolarisCallContext callCtx, long policyCatalogId, long policyId, int policyTypeCode) {
        return this.store.getSlicePolicyMappingRecordsByPolicy().readRange(this.store.buildPrefixKeyComposite(policyTypeCode, policyCatalogId, policyId));
    }

    private Optional<String> getEntityLocationWithoutScheme(PolarisBaseEntity entity) {
        if (entity.getType() == PolarisEntityType.TABLE_LIKE && (entity.getSubType() == PolarisEntitySubType.ICEBERG_TABLE || entity.getSubType() == PolarisEntitySubType.ICEBERG_VIEW)) {
            return Optional.of(StorageLocation.of(entity.getPropertiesAsMap().get("location")).withoutScheme());
        }
        if (entity.getType() == PolarisEntityType.NAMESPACE) {
            return Optional.of(StorageLocation.of(entity.getPropertiesAsMap().get("location")).withoutScheme());
        }
        return Optional.empty();
    }

    @Override
    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        StorageLocation entityLocationWithoutScheme = StorageLocation.of(StorageLocation.of(((LocationBasedEntity)((Object)entity)).getBaseLocation()).withoutScheme());
        List<PolarisBaseEntity> allEntities = this.store.getSliceEntities().readRange("");
        for (PolarisBaseEntity siblingEntity : allEntities) {
            Optional<StorageLocation> maybeSiblingLocationWithoutScheme = this.getEntityLocationWithoutScheme(siblingEntity).map(StorageLocation::of);
            if (!maybeSiblingLocationWithoutScheme.isPresent() || !maybeSiblingLocationWithoutScheme.get().isChildOf(entityLocationWithoutScheme) && !entityLocationWithoutScheme.isChildOf(maybeSiblingLocationWithoutScheme.get())) continue;
            return Optional.of(Optional.of(maybeSiblingLocationWithoutScheme.toString()));
        }
        return Optional.of(Optional.empty());
    }
}

