/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.commons.utils.BlobUtils;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BinaryLiteral
extends Literal {
    private final byte[] values;

    public BinaryLiteral(String value) {
        try {
            this.values = BlobUtils.parseBlobString((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    public BinaryLiteral(byte[] values) {
        this.values = values;
    }

    public byte[] getValues() {
        return this.values;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.BINARY.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Binary)new Binary(this.values), (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.BINARY.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((Binary)new Binary(this.values), (OutputStream)stream);
    }

    @Override
    public Binary getBinary() {
        return new Binary(this.values);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        return dataType == TSDataType.BLOB;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.BLOB.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

