/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionLogSource
extends PipeRealtimeDataRegionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionLogSource.class);

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        EnrichedEvent eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
            event.getTsFileEpoch().clearState(this);
        } else if (eventToExtract instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else if (eventToExtract instanceof PipeSchemaRegionWritePlanEvent) {
            this.extractDirectly(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for log realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TABLET);
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionLogExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogSource.class.getName(), false);
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)event.getEvent();
        if (!tsFileInsertionEvent.isLoaded()) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogSource.class.getName(), false);
            return;
        }
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionLogExtractor %s has reached capacity, discard loaded tsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogSource.class.getName(), false);
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return this.shouldExtractInsertion;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return this.shouldExtractInsertion;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent = null;
            if (realtimeEvent.getEvent() instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else if (realtimeEvent.getEvent() instanceof PipeSchemaRegionWritePlanEvent || realtimeEvent.getEvent() instanceof ProgressReportEvent) {
                suppliedEvent = this.supplyDirectly(realtimeEvent);
            } else if (realtimeEvent.increaseReferenceCount(PipeRealtimeDataRegionLogSource.class.getName())) {
                suppliedEvent = realtimeEvent.getEvent();
            } else {
                String errorMessage = String.format("Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", realtimeEvent.getEvent());
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionLogSource.class.getName(), false);
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }
}

