/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.ParsingException;

class ChunkedBody
extends MessageBody {
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private long position = 0L;
    private long remaining = 0L;
    private long chunkLength = -1L;
    private boolean finished;
    private int cs = 1;
    private long tmp;
    private static final byte[] _chunked_actions = ChunkedBody.init__chunked_actions_0();
    private static final short[] _chunked_key_offsets = ChunkedBody.init__chunked_key_offsets_0();
    private static final char[] _chunked_trans_keys = ChunkedBody.init__chunked_trans_keys_0();
    private static final byte[] _chunked_single_lengths = ChunkedBody.init__chunked_single_lengths_0();
    private static final byte[] _chunked_range_lengths = ChunkedBody.init__chunked_range_lengths_0();
    private static final short[] _chunked_index_offsets = ChunkedBody.init__chunked_index_offsets_0();
    private static final byte[] _chunked_indicies = ChunkedBody.init__chunked_indicies_0();
    private static final byte[] _chunked_trans_targs = ChunkedBody.init__chunked_trans_targs_0();
    private static final byte[] _chunked_trans_actions = ChunkedBody.init__chunked_trans_actions_0();
    static final int chunked_start = 1;
    static final int chunked_first_final = 31;
    static final int chunked_error = 0;
    static final int chunked_en_chunks = 1;

    public ChunkedBody(ReadableByteChannel channel, ByteBuffer buffer) {
        this.channel = channel;
        this.buffer = buffer;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        while (this.chunkLength != 0L) {
            if (!this.buffer.hasRemaining()) {
                if (this.remaining >= (long)this.buffer.capacity() && dst.remaining() >= this.buffer.capacity()) {
                    int n = IOUtils.transfer(this.channel, dst, this.remaining);
                    if (n < 0) {
                        throw new EOFException("EOF reached before end of chunked encoding");
                    }
                    this.remaining -= (long)n;
                    this.position += (long)n;
                    return n;
                }
                this.buffer.compact();
                if (this.channel.read(this.buffer) < 0) {
                    throw new EOFException("EOF reached before end of chunked encoding");
                }
                this.buffer.flip();
            }
            if (this.remaining > 0L) {
                int n = IOUtils.transfer(this.buffer, dst, this.remaining);
                this.remaining -= (long)n;
                this.position += (long)n;
                return n;
            }
            this.chunkLength = -1L;
            this.parse();
            this.remaining = this.chunkLength;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void parse() throws ParsingException {
        p = this.buffer.position();
        pe = this.buffer.limit();
        _trans = 0;
        _goto_targ = 0;
        block10: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block10;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block10;
                    }
                }
                case 1: {
                    _keys = ChunkedBody._chunked_key_offsets[this.cs];
                    _trans = ChunkedBody._chunked_index_offsets[this.cs];
                    _klen = ChunkedBody._chunked_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl33
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (this.buffer.get(p) < ChunkedBody._chunked_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (this.buffer.get(p) > ChunkedBody._chunked_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl47
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl33:
                    // 2 sources

                    if ((_klen = ChunkedBody._chunked_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (this.buffer.get(p) < ChunkedBody._chunked_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (this.buffer.get(p) > ChunkedBody._chunked_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl47
                        }
                        _trans += _klen;
                    }
lbl47:
                    // 5 sources

                    _trans = ChunkedBody._chunked_indicies[_trans];
                    this.cs = ChunkedBody._chunked_trans_targs[_trans];
                    if (ChunkedBody._chunked_trans_actions[_trans] != 0) {
                        _acts = ChunkedBody._chunked_trans_actions[_trans];
                        _nacts = ChunkedBody._chunked_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (ChunkedBody._chunked_actions[_acts++]) {
                                case 0: {
                                    this.tmp = this.tmp * 16L + (long)Character.digit(this.buffer.get(p), 16);
                                    break;
                                }
                                case 1: {
                                    if (this.tmp == 0L) break;
                                    this.chunkLength = this.tmp;
                                    this.tmp = 0L;
                                    ++p;
                                    _goto_targ = 5;
                                    continue block10;
                                }
                                case 2: {
                                    this.chunkLength = 0L;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block10;
                    }
                    if (++p == pe) break block10;
                    _goto_targ = 1;
                    continue block10;
                }
            }
            break;
        }
        this.buffer.position(p);
        if (this.cs == 0) {
            throw new ParsingException("chunked encoding at position " + p + ": " + ChunkedBody.getErrorContext(this.buffer, p, 40));
        }
    }

    private static byte[] init__chunked_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2};
    }

    private static short[] init__chunked_key_offsets_0() {
        return new short[]{0, 0, 7, 18, 21, 22, 38, 39, 49, 52, 53, 54, 55, 70, 86, 101, 120, 127, 131, 137, 153, 159, 160, 178, 179, 194, 210, 225, 244, 251, 255, 261, 268};
    }

    private static char[] init__chunked_trans_keys_0() {
        return new char[]{'0', '1', '9', 'A', 'F', 'a', 'f', '\t', '\r', ' ', '0', ';', '1', '9', 'A', 'F', 'a', 'f', '\t', '\r', ' ', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '\t', '\r', ' ', ';', '0', '9', 'A', 'F', 'a', 'f', '\t', '\r', ' ', '\n', '\r', '\n', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\"', '\\', ' ', '~', '\u0080', '\u00ff', '\t', '\r', ' ', ';', '\u0000', '\t', '\u000b', '\f', '\u000e', '\u007f', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\"', '\\', ' ', '~', '\u0080', '\u00ff', '\t', '\r', ' ', ';', '\u0000', '\t', '\u000b', '\f', '\u000e', '\u007f', '0', '1', '9', 'A', 'F', 'a', 'f', '\u0000'};
    }

    private static byte[] init__chunked_single_lengths_0() {
        return new byte[]{0, 1, 5, 3, 1, 4, 1, 4, 3, 1, 1, 1, 3, 4, 3, 7, 3, 4, 0, 4, 2, 1, 6, 1, 3, 4, 3, 7, 3, 4, 0, 1, 0};
    }

    private static byte[] init__chunked_range_lengths_0() {
        return new byte[]{0, 3, 3, 0, 0, 6, 0, 3, 0, 0, 0, 0, 6, 6, 6, 6, 2, 0, 3, 6, 2, 0, 6, 0, 6, 6, 6, 6, 2, 0, 3, 3, 0};
    }

    private static short[] init__chunked_index_offsets_0() {
        return new short[]{0, 0, 5, 14, 18, 20, 31, 33, 41, 45, 47, 49, 51, 61, 72, 82, 96, 102, 107, 111, 122, 127, 129, 142, 144, 154, 165, 175, 189, 195, 200, 204, 209};
    }

    private static byte[] init__chunked_indicies_0() {
        return new byte[]{0, 2, 2, 2, 1, 3, 4, 3, 0, 5, 2, 2, 2, 1, 3, 4, 3, 1, 6, 1, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 1, 9, 1, 10, 11, 10, 12, 2, 2, 2, 1, 10, 11, 10, 1, 13, 1, 14, 1, 15, 1, 16, 16, 16, 16, 16, 16, 16, 16, 16, 1, 16, 17, 16, 16, 16, 16, 16, 16, 16, 16, 1, 19, 18, 18, 18, 18, 18, 18, 18, 18, 1, 10, 11, 10, 18, 12, 18, 18, 18, 18, 18, 18, 18, 18, 1, 19, 20, 21, 19, 19, 1, 10, 11, 10, 12, 1, 19, 19, 19, 1, 8, 22, 8, 8, 8, 8, 8, 8, 8, 8, 1, 22, 23, 22, 22, 1, 24, 1, 22, 25, 22, 8, 8, 8, 8, 8, 8, 8, 8, 8, 1, 26, 1, 27, 27, 27, 27, 27, 27, 27, 27, 27, 1, 27, 28, 27, 27, 27, 27, 27, 27, 27, 27, 1, 30, 29, 29, 29, 29, 29, 29, 29, 29, 1, 3, 4, 3, 29, 5, 29, 29, 29, 29, 29, 29, 29, 29, 1, 30, 31, 32, 30, 30, 1, 3, 4, 3, 5, 1, 30, 30, 30, 1, 0, 2, 2, 2, 1, 1, 0};
    }

    private static byte[] init__chunked_trans_targs_0() {
        return new byte[]{2, 0, 7, 3, 4, 24, 5, 6, 19, 31, 8, 9, 12, 10, 11, 1, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 32, 25, 26, 27, 28, 29, 30};
    }

    private static byte[] init__chunked_trans_actions_0() {
        return new byte[]{1, 0, 1, 0, 0, 0, 3, 0, 0, 5, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0};
    }
}

