/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;

@XmlType(name="serviceCallConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class ServiceCallConfiguration
extends IdentifiedType {
    @XmlElement(name="properties")
    @Metadata(label="advanced")
    protected List<PropertyDefinition> properties;

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public ServiceCallConfiguration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.properties.add(prop);
        return this;
    }

    protected Map<String, String> getPropertiesAsMap(CamelContext camelContext) throws Exception {
        Map<String, String> answer;
        if (this.properties == null || this.properties.isEmpty()) {
            answer = Collections.emptyMap();
        } else {
            answer = new HashMap<String, String>();
            for (PropertyDefinition prop : this.properties) {
                String key = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getKey());
                String value = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
    }
}

