/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.io.SocketConfig;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.Empty;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpComponentsRedirectStrategy;
import org.springframework.boot.http.client.HttpComponentsSslBundleTlsStrategy;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.util.Assert;

public final class HttpComponentsHttpClientBuilder {
    private final Consumer<HttpClientBuilder> customizer;
    private final Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer;
    private final Consumer<SocketConfig.Builder> socketConfigCustomizer;
    private final Consumer<ConnectionConfig.Builder> connectionConfigCustomizer;
    private final Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer;
    private final Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory;

    public HttpComponentsHttpClientBuilder() {
        this(Empty.consumer(), Empty.consumer(), Empty.consumer(), Empty.consumer(), Empty.consumer(), HttpComponentsSslBundleTlsStrategy::get);
    }

    private HttpComponentsHttpClientBuilder(Consumer<HttpClientBuilder> customizer, Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer, Consumer<SocketConfig.Builder> socketConfigCustomizer, Consumer<ConnectionConfig.Builder> connectionConfigCustomizer, Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer, Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory) {
        this.customizer = customizer;
        this.connectionManagerCustomizer = connectionManagerCustomizer;
        this.socketConfigCustomizer = socketConfigCustomizer;
        this.connectionConfigCustomizer = connectionConfigCustomizer;
        this.defaultRequestConfigCustomizer = defaultRequestConfigCustomizer;
        this.tlsSocketStrategyFactory = tlsSocketStrategyFactory;
    }

    public HttpComponentsHttpClientBuilder withCustomizer(Consumer<HttpClientBuilder> customizer) {
        Assert.notNull(customizer, (String)"'customizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer.andThen(customizer), this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withConnectionManagerCustomizer(Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, (String)"'connectionManagerCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer.andThen(connectionManagerCustomizer), this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withSocketConfigCustomizer(Consumer<SocketConfig.Builder> socketConfigCustomizer) {
        Assert.notNull(socketConfigCustomizer, (String)"'socketConfigCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer.andThen(socketConfigCustomizer), this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withConnectionConfigCustomizer(Consumer<ConnectionConfig.Builder> connectionConfigCustomizer) {
        Assert.notNull(connectionConfigCustomizer, (String)"'connectionConfigCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer.andThen(connectionConfigCustomizer), this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withTlsSocketStrategyFactory(Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory) {
        Assert.notNull(tlsSocketStrategyFactory, (String)"'tlsSocketStrategyFactory' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, (String)"'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer.andThen(defaultRequestConfigCustomizer), this.tlsSocketStrategyFactory);
    }

    public CloseableHttpClient build(HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setRedirectStrategy(HttpComponentsRedirectStrategy.get(settings.redirects())).setConnectionManager((HttpClientConnectionManager)this.createConnectionManager(settings)).setDefaultRequestConfig(this.createDefaultRequestConfig());
        this.customizer.accept(builder);
        return builder.build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpClientSettings settings) {
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties();
        PropertyMapper map = PropertyMapper.get();
        builder.setDefaultSocketConfig(this.createSocketConfig());
        builder.setDefaultConnectionConfig(this.createConnectionConfig(settings));
        map.from(settings::sslBundle).as(this.tlsSocketStrategyFactory).whenNonNull().to(arg_0 -> ((PoolingHttpClientConnectionManagerBuilder)builder).setTlsSocketStrategy(arg_0));
        this.connectionManagerCustomizer.accept(builder);
        return builder.build();
    }

    private SocketConfig createSocketConfig() {
        SocketConfig.Builder builder = SocketConfig.custom();
        this.socketConfigCustomizer.accept(builder);
        return builder.build();
    }

    private ConnectionConfig createConnectionConfig(HttpClientSettings settings) {
        ConnectionConfig.Builder builder = ConnectionConfig.custom();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).as(Duration::toMillis).to(timeout -> builder.setConnectTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(timeout -> builder.setSocketTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        this.connectionConfigCustomizer.accept(builder);
        return builder.build();
    }

    private RequestConfig createDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        this.defaultRequestConfigCustomizer.accept(builder);
        return builder.build();
    }
}

