/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoLFOutputStream
extends OutputStream {
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[RawText.getBufferSize()];
    private byte[] onebytebuf = new byte[1];
    private int binbufcnt = 0;
    private boolean detectBinary;
    private boolean isBinary;

    public AutoLFOutputStream(OutputStream out) {
        this(out, true);
    }

    public AutoLFOutputStream(OutputStream out, boolean detectBinary) {
        this.out = out;
        this.detectBinary = detectBinary;
    }

    @Override
    public void write(int b) throws IOException {
        this.onebytebuf[0] = (byte)b;
        this.write(this.onebytebuf, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        int overflow = this.buffer(b, 0, b.length);
        if (overflow > 0) {
            this.write(b, b.length - overflow, overflow);
        }
    }

    @Override
    public void write(byte[] b, int startOff, int startLen) throws IOException {
        int overflow = this.buffer(b, startOff, startLen);
        if (overflow <= 0) {
            return;
        }
        int off = startOff + startLen - overflow;
        int len = overflow;
        int lastw = off;
        if (this.isBinary) {
            this.out.write(b, off, len);
            return;
        }
        int i = off;
        while (i < off + len) {
            byte c = b[i];
            switch (c) {
                case 13: {
                    if (lastw < i) {
                        this.out.write(b, lastw, i - lastw);
                    }
                    lastw = i + 1;
                    this.buf = 13;
                    break;
                }
                case 10: {
                    if (this.buf == 13) {
                        this.out.write(10);
                        lastw = i + 1;
                        this.buf = -1;
                        break;
                    }
                    if (lastw < i + 1) {
                        this.out.write(b, lastw, i + 1 - lastw);
                    }
                    lastw = i + 1;
                    break;
                }
                default: {
                    if (this.buf == 13) {
                        this.out.write(13);
                        lastw = i;
                    }
                    this.buf = -1;
                }
            }
            ++i;
        }
        if (lastw < off + len) {
            this.out.write(b, lastw, off + len - lastw);
        }
    }

    private int buffer(byte[] b, int off, int len) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return len;
        }
        int copy = Math.min(this.binbuf.length - this.binbufcnt, len);
        System.arraycopy(b, off, this.binbuf, this.binbufcnt, copy);
        this.binbufcnt += copy;
        int remaining = len - copy;
        if (remaining > 0) {
            this.decideMode(false);
        }
        return remaining;
    }

    private void decideMode(boolean complete) throws IOException {
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt, complete);
            if (!this.isBinary) {
                this.isBinary = RawText.isCrLfText(this.binbuf, this.binbufcnt, complete);
            }
            this.detectBinary = false;
        }
        int cachedLen = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, cachedLen);
    }

    @Override
    public void flush() throws IOException {
        if (this.binbufcnt <= this.binbuf.length) {
            this.decideMode(true);
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.buf == 13) {
            this.out.write(this.buf);
            this.buf = -1;
        }
        this.out.close();
    }
}

