/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.authorization;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.registry.authorization.AccessPolicySummary;
import org.apache.nifi.registry.authorization.ResourcePermissions;
import org.apache.nifi.registry.revision.entity.RevisableEntity;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class Tenant
implements RevisableEntity {
    private String identifier;
    private String identity;
    private Boolean configurable;
    private ResourcePermissions resourcePermissions;
    private Set<AccessPolicySummary> accessPolicies;
    private RevisionInfo revision;

    public Tenant() {
    }

    public Tenant(String identifier, String identity) {
        this.identifier = identifier;
        this.identity = identity;
    }

    @Schema(description="The computer-generated identifier of the tenant.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The human-facing identity of the tenant. This can only be changed if the tenant is configurable.")
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Schema(description="Indicates if this tenant is configurable, based on which UserGroupProvider has been configured to manage it.", accessMode=Schema.AccessMode.READ_ONLY)
    public Boolean getConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    @Schema(description="A summary top-level resource access policies granted to this tenant.", accessMode=Schema.AccessMode.READ_ONLY)
    public ResourcePermissions getResourcePermissions() {
        return this.resourcePermissions;
    }

    public void setResourcePermissions(ResourcePermissions resourcePermissions) {
        this.resourcePermissions = resourcePermissions;
    }

    @Schema(description="The access policies granted to this tenant.", accessMode=Schema.AccessMode.READ_ONLY)
    public Set<AccessPolicySummary> getAccessPolicies() {
        return this.accessPolicies;
    }

    public void setAccessPolicies(Set<AccessPolicySummary> accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    public void addAccessPolicies(Collection<AccessPolicySummary> accessPolicies) {
        if (accessPolicies != null) {
            if (this.accessPolicies == null) {
                this.accessPolicies = new HashSet<AccessPolicySummary>();
            }
            this.accessPolicies.addAll(accessPolicies);
        }
    }

    @Schema(description="The revision of this entity used for optimistic-locking during updates.", accessMode=Schema.AccessMode.READ_ONLY)
    public RevisionInfo getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionInfo revision) {
        this.revision = revision;
    }
}

