/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.models;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import opennlp.tools.models.ClassPathLoaderException;
import opennlp.tools.models.ClassPathModel;
import opennlp.tools.models.ClassPathModelEntry;
import opennlp.tools.models.ModelType;
import opennlp.tools.util.model.BaseModel;

public class ClassPathModelLoader {
    public ClassPathModel load(ClassPathModelEntry entry) throws IOException {
        byte[] model;
        Objects.requireNonNull(entry, "entry must not be null");
        Objects.requireNonNull(entry.properties(), "entry.properties() must not be null");
        Objects.requireNonNull(entry.model(), "entry.model() must not be null");
        Properties properties = new Properties();
        if (entry.properties().isPresent()) {
            try (BufferedInputStream inputStream = new BufferedInputStream(entry.properties().get().toURL().openStream());){
                properties.load(inputStream);
            }
        }
        try (InputStream inputStream = entry.model().toURL().openStream();){
            model = inputStream.readAllBytes();
        }
        return new ClassPathModel(properties, model);
    }

    <T extends BaseModel> T load(Set<ClassPathModelEntry> classPathEntries, String lang, ModelType type, Class<T> modelType) throws IOException {
        if (type == null) {
            throw new IllegalArgumentException("ModelType must not be null.");
        }
        return this.load(classPathEntries, lang, type.getName(), modelType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <T extends BaseModel> T load(Set<ClassPathModelEntry> classPathEntries, String lang, String type, Class<T> modelType) throws IOException {
        if (classPathEntries == null) {
            throw new IllegalArgumentException("The provided ClassPath entries must not be null!");
        }
        if (lang == null || lang.isBlank()) {
            throw new IllegalArgumentException("The provided language must not be null and not be empty!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The provided ModelType must not be null!");
        }
        BaseModel result = null;
        if (classPathEntries.isEmpty()) {
            return (T)result;
        }
        try {
            for (ClassPathModelEntry entry : classPathEntries) {
                ClassPathModel cpm = this.load(entry);
                if (cpm == null || !cpm.getModelLanguage().equals(lang) || !cpm.getModelName().contains(type)) continue;
                BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(cpm.model()));
                try {
                    result = (BaseModel)modelType.getConstructor(InputStream.class).newInstance(is);
                    return (T)result;
                }
                finally {
                    ((InputStream)is).close();
                    return (T)result;
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassPathLoaderException(e);
        }
    }
}

