/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import opennlp.tools.util.Span;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class AbstractSentenceDetector
extends CasAnnotator_ImplBase {
    protected UimaContext context;
    protected Logger logger;
    protected Type containerType;
    protected Type sentenceType;
    private Boolean isRemoveExistingAnnotations;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.context = context;
        this.logger = context.getLogger();
        if (this.logger.isLoggable(Level.DEBUG)) {
            this.logger.log(Level.DEBUG, "Initializing the OpenNLP Sentence annotator.");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(context, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.containerType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.ContainerType");
        if (this.containerType == null) {
            this.containerType = typeSystem.getType("uima.tcas.DocumentAnnotation");
        }
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.SentenceType");
    }

    protected abstract Span[] detectSentences(String var1);

    protected void postProcessAnnotations(AnnotationFS[] sentences) {
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        AnnotationIndex containerAnnotations = cas.getAnnotationIndex(this.containerType);
        for (AnnotationFS containerAnnotation : containerAnnotations) {
            String text = containerAnnotation.getCoveredText();
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cas, containerAnnotation, this.sentenceType);
            }
            Span[] sentPositions = this.detectSentences(text);
            AnnotationFS[] sentences = new AnnotationFS[sentPositions.length];
            for (int i = 0; i < sentPositions.length; ++i) {
                sentences[i] = cas.createAnnotation(this.sentenceType, sentPositions[i].getStart() + containerAnnotation.getBegin(), sentPositions[i].getEnd() + containerAnnotation.getBegin());
                cas.getIndexRepository().addFS((FeatureStructure)sentences[i]);
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINER, "\"" + sentences[i].getCoveredText() + "\"");
            }
            this.postProcessAnnotations(sentences);
        }
    }
}

