/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttributeOrStatistic;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

abstract class ConfiguredObjectMethodAttributeOrStatistic<C extends ConfiguredObject, T>
implements ConfiguredObjectAttributeOrStatistic<C, T> {
    private final String _name;
    private final Class<T> _type;
    private final Method _getter;

    ConfiguredObjectMethodAttributeOrStatistic(Method getter) {
        this._getter = getter;
        this._type = AttributeValueConverter.getTypeFromMethod(getter);
        this._name = AttributeValueConverter.getNameFromMethod(getter, this.getType());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Class<T> getType() {
        return this._type;
    }

    @Override
    public Type getGenericType() {
        return this.getGetter().getGenericReturnType();
    }

    @Override
    public T getValue(C configuredObject) {
        try {
            return (T)this.getGetter().invoke(configuredObject, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
    }

    public Method getGetter() {
        return this._getter;
    }
}

