/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BrowserStorage;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class DefaultBrowserStorage
implements BrowserStorage {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).minimal(true).build().toObjectMapper();
    private static final long serialVersionUID = 775566570310426414L;
    private String payload;
    private String destinationUrl;
    private String context;
    private BrowserStorage.BrowserStorageTypes storageType;

    @JsonIgnore
    public Map<String, Object> getPayloadJson() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            LinkedHashMap jsonPayload = (LinkedHashMap)MAPPER.readValue(this.payload, LinkedHashMap.class);
            if (jsonPayload.containsKey(this.context)) {
                String decoded = EncodingUtils.decodeBase64ToString((String)jsonPayload.get(this.context).toString());
                return (Map)MAPPER.readValue(decoded, LinkedHashMap.class);
            }
            return Map.of();
        });
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    public BrowserStorage setPayloadJson(Object payload) {
        FunctionUtils.doAndHandle(__ -> this.setPayload(EncodingUtils.encodeBase64((String)MAPPER.writeValueAsString(payload))));
        return this;
    }

    @Generated
    private static String $default$context() {
        return "CasBrowserStorageContext";
    }

    @Generated
    private static BrowserStorage.BrowserStorageTypes $default$storageType() {
        return BrowserStorage.BrowserStorageTypes.SESSION;
    }

    @Generated
    protected DefaultBrowserStorage(DefaultBrowserStorageBuilder<?, ?> b) {
        this.payload = b.payload;
        this.destinationUrl = b.destinationUrl;
        this.context = b.context$set ? b.context$value : DefaultBrowserStorage.$default$context();
        this.storageType = b.storageType$set ? b.storageType$value : DefaultBrowserStorage.$default$storageType();
    }

    @Generated
    public static DefaultBrowserStorageBuilder<?, ?> builder() {
        return new DefaultBrowserStorageBuilderImpl();
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public BrowserStorage.BrowserStorageTypes getStorageType() {
        return this.storageType;
    }

    @Generated
    public String toString() {
        return "DefaultBrowserStorage(payload=" + this.payload + ", destinationUrl=" + this.destinationUrl + ", context=" + this.context + ", storageType=" + String.valueOf(this.storageType) + ")";
    }

    @Generated
    public DefaultBrowserStorage setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    @Generated
    public DefaultBrowserStorage setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
        return this;
    }

    @Generated
    public DefaultBrowserStorage setContext(String context) {
        this.context = context;
        return this;
    }

    @Generated
    public DefaultBrowserStorage setStorageType(BrowserStorage.BrowserStorageTypes storageType) {
        this.storageType = storageType;
        return this;
    }

    @Generated
    public DefaultBrowserStorage() {
        this.context = DefaultBrowserStorage.$default$context();
        this.storageType = DefaultBrowserStorage.$default$storageType();
    }

    @Generated
    public static abstract class DefaultBrowserStorageBuilder<C extends DefaultBrowserStorage, B extends DefaultBrowserStorageBuilder<C, B>> {
        @Generated
        private String payload;
        @Generated
        private String destinationUrl;
        @Generated
        private boolean context$set;
        @Generated
        private String context$value;
        @Generated
        private boolean storageType$set;
        @Generated
        private BrowserStorage.BrowserStorageTypes storageType$value;

        @Generated
        public B payload(String payload) {
            this.payload = payload;
            return this.self();
        }

        @Generated
        public B destinationUrl(String destinationUrl) {
            this.destinationUrl = destinationUrl;
            return this.self();
        }

        @Generated
        public B context(String context) {
            this.context$value = context;
            this.context$set = true;
            return this.self();
        }

        @Generated
        public B storageType(BrowserStorage.BrowserStorageTypes storageType) {
            this.storageType$value = storageType;
            this.storageType$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DefaultBrowserStorage.DefaultBrowserStorageBuilder(payload=" + this.payload + ", destinationUrl=" + this.destinationUrl + ", context$value=" + this.context$value + ", storageType$value=" + String.valueOf(this.storageType$value) + ")";
        }
    }

    @Generated
    private static final class DefaultBrowserStorageBuilderImpl
    extends DefaultBrowserStorageBuilder<DefaultBrowserStorage, DefaultBrowserStorageBuilderImpl> {
        @Generated
        private DefaultBrowserStorageBuilderImpl() {
        }

        @Override
        @Generated
        protected DefaultBrowserStorageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DefaultBrowserStorage build() {
            return new DefaultBrowserStorage(this);
        }
    }
}

