/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.spi.AuditActionDateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="auditLog", defaultAccess=Access.NONE)
public class AuditLogEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogEndpoint.class);
    private final ObjectProvider<AuditTrailExecutionPlan> auditTrailManager;
    private final ObjectProvider<AuditActionDateProvider> auditActionDateProvider;

    public AuditLogEndpoint(ObjectProvider<AuditTrailExecutionPlan> auditTrailManager, ConfigurableApplicationContext applicationContext, ObjectProvider<AuditActionDateProvider> auditActionDateProvider, CasConfigurationProperties casProperties) {
        super(casProperties, applicationContext);
        this.auditActionDateProvider = auditActionDateProvider;
        this.auditTrailManager = auditTrailManager;
    }

    private Stream<AuditActionContext> getAuditLog(String interval, long count) {
        if (StringUtils.isBlank((CharSequence)interval)) {
            LocalDateTime sinceDate = ((LocalDateTime)((AuditActionDateProvider)this.auditActionDateProvider.getObject()).get()).minusDays(this.casProperties.getAudit().getEngine().getNumberOfDaysInHistory());
            return ((AuditTrailExecutionPlan)this.auditTrailManager.getObject()).getAuditRecords(Map.of(AuditTrailManager.WhereClauseFields.DATE, sinceDate, AuditTrailManager.WhereClauseFields.COUNT, count)).parallelStream();
        }
        Duration duration = Beans.newDuration((String)interval);
        LocalDateTime startingDate = LocalDateTime.from(duration.subtractFrom((Temporal)((AuditActionDateProvider)this.auditActionDateProvider.getObject()).get()));
        LOGGER.debug("Fetching audit records since [{}]", (Object)startingDate);
        List initialRecords = ((AuditTrailExecutionPlan)this.auditTrailManager.getObject()).getAuditRecords(Map.of(AuditTrailManager.WhereClauseFields.DATE, startingDate));
        LOGGER.debug("Filtering audit records that are after [{}]", (Object)startingDate);
        return initialRecords.parallelStream().filter(rec -> rec.getWhenActionWasPerformed().isAfter(startingDate));
    }

    @GetMapping(produces={"application/json"}, consumes={"application/json", "application/x-www-form-urlencoded"})
    @Operation(summary="Provide a report of the audit log. Each filter other than `interval` can accept a regular expression to match against.", parameters={@Parameter(name="count", description="Total number of records to fetch from audit log"), @Parameter(name="interval", description="Accepts the duration syntax, such as PT1H"), @Parameter(name="actionPerformed", description="The action performed"), @Parameter(name="clientIpAddress", description="The client IP address"), @Parameter(name="principal", description="The principal"), @Parameter(name="resourceOperatedUpon", description="The resource operated upon")})
    public List<AuditActionContext> getAuditLog(@RequestParam(required=false, defaultValue="10") int count, @RequestParam(required=false) String interval, @RequestParam(required=false) String actionPerformed, @RequestParam(required=false) String clientIpAddress, @RequestParam(required=false) String principal, @RequestParam(required=false) String resourceOperatedUpon) {
        List<AuditActionContext> records = this.getAuditLog(interval, count).filter(e -> StringUtils.isBlank((CharSequence)actionPerformed) || RegexUtils.find((String)actionPerformed, (String)e.getActionPerformed())).filter(e -> StringUtils.isBlank((CharSequence)clientIpAddress) || RegexUtils.find((String)clientIpAddress, (String)e.getClientInfo().getClientIpAddress())).filter(e -> StringUtils.isBlank((CharSequence)principal) || RegexUtils.find((String)principal, (String)e.getPrincipal())).filter(e -> StringUtils.isBlank((CharSequence)resourceOperatedUpon) || RegexUtils.find((String)resourceOperatedUpon, (String)e.getResourceOperatedUpon())).toList();
        LOGGER.debug("Found [{}] audit log records", (Object)records.size());
        return records;
    }
}

