/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.RepositoryMethodContext;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.util.Assert;

public class DefaultRepositoryMethodContext
implements RepositoryMethodContext {
    private final RepositoryMetadata repositoryMetadata;
    private final Method method;

    DefaultRepositoryMethodContext(RepositoryMetadata repositoryMetadata, Method method) {
        this.repositoryMetadata = repositoryMetadata;
        this.method = method;
    }

    public static RepositoryMethodContext forMethod(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return new DefaultRepositoryMethodContext(AbstractRepositoryMetadata.getMetadata(method.getDeclaringClass()), method);
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.repositoryMetadata;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }
}

