/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.pac4j.core.profile.Pac4JPrincipal;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUserProfile
implements UserProfile,
Externalizable {
    private static final long serialVersionUID = 9020114478664816338L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String id;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> authenticationAttributes = new HashMap<String, Object>();
    private boolean isRemembered = false;
    private Set<String> roles = new HashSet<String>();
    private String clientName;
    private String linkedId;
    private final boolean canAttributesBeMerged;

    public BasicUserProfile() {
        this(true);
    }

    public BasicUserProfile(boolean canAttributesBeMerged) {
        this.canAttributesBeMerged = canAttributesBeMerged;
    }

    public void build(Object id, Map<String, Object> attributes) {
        this.setId(ProfileHelper.sanitizeIdentifier(id));
        this.addAttributes(attributes);
    }

    public void build(Object id, Map<String, Object> attributes, Map<String, Object> authenticationAttributes) {
        this.build(id, attributes);
        this.addAuthenticationAttributes(authenticationAttributes);
    }

    @Override
    public void setId(String id) {
        CommonHelper.assertNotBlank("id", id);
        this.id = id;
    }

    @Override
    @JsonIgnore
    public String getTypedId() {
        return this.getClass().getName() + "#" + this.id;
    }

    @Override
    public String getUsername() {
        return null;
    }

    private void addAttributeToMap(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            this.logger.debug("adding => key: {} / value: {} / {}", new Object[]{key, value, value.getClass()});
            Object valueForMap = this.getValueForMap(map, key, value);
            map.put(key, valueForMap);
        }
    }

    private Object getValueForMap(Map<String, Object> map, String key, Object preparedValue) {
        if (this.canMergeAttributes(map, key, preparedValue)) {
            Collection existingCollection = (Collection)map.get(key);
            Collection newCollection = (Collection)preparedValue;
            return BasicUserProfile.mergeCollectionAttributes(existingCollection, newCollection);
        }
        return preparedValue;
    }

    private boolean canMergeAttributes(Map<String, Object> map, String key, Object preparedValue) {
        return this.canAttributesBeMerged && preparedValue instanceof Collection && map.get(key) instanceof Collection;
    }

    private static <T> Collection<T> mergeCollectionAttributes(Collection<T> existingCollection, Collection<T> newCollection) {
        return Streams.concat((Stream[])new Stream[]{existingCollection.stream(), newCollection.stream()}).distinct().collect(Collectors.toList());
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.addAttributeToMap(this.attributes, key, value);
    }

    @Override
    public void addAuthenticationAttribute(String key, Object value) {
        this.addAttributeToMap(this.authenticationAttributes, key, value);
    }

    public void addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.addAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addAuthenticationAttributes(Map<String, Object> attributeMap) {
        if (attributeMap != null) {
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                this.addAuthenticationAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void removeAttribute(String key) {
        CommonHelper.assertNotNull("key", key);
        this.attributes.remove(key);
    }

    @Override
    public void removeAuthenticationAttribute(String key) {
        CommonHelper.assertNotNull("key", key);
        this.authenticationAttributes.remove(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return BasicUserProfile.getAttributeMap(this.attributes);
    }

    public Map<String, Object> getAuthenticationAttributes() {
        return BasicUserProfile.getAttributeMap(this.authenticationAttributes);
    }

    private static Map<String, Object> getAttributeMap(Map<String, Object> attributeMap) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entries : attributeMap.entrySet()) {
            String key = entries.getKey();
            Object value = attributeMap.get(key);
            newAttributes.put(key, value);
        }
        return newAttributes;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<String> extractAttributeValues(String name) {
        Object value = this.getAttribute(name);
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }

    public Object getAuthenticationAttribute(String name) {
        return this.authenticationAttributes.get(name);
    }

    @Override
    public boolean containsAttribute(String name) {
        CommonHelper.assertNotNull("name", name);
        return this.attributes.containsKey(name);
    }

    public boolean containsAuthenticationAttribute(String name) {
        CommonHelper.assertNotNull("name", name);
        return this.authenticationAttributes.containsKey(name);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object attribute = this.getAttribute(name);
        return BasicUserProfile.getAttributeByType(name, clazz, attribute);
    }

    public <T> T getAuthenticationAttribute(String name, Class<T> clazz) {
        Object attribute = this.getAuthenticationAttribute(name);
        return BasicUserProfile.getAttributeByType(name, clazz, attribute);
    }

    private static <T> T getAttributeByType(String name, Class<T> clazz, Object attribute) {
        if (attribute == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(attribute.getClass())) {
            throw new ClassCastException("Attribute [" + name + " is of type " + attribute.getClass() + " when we were expecting " + clazz);
        }
        return (T)attribute;
    }

    @Override
    public void addRole(String role) {
        CommonHelper.assertNotBlank("role", role);
        this.roles.add(role);
    }

    @Override
    public void addRoles(Collection<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles.addAll(roles);
    }

    @Override
    public Set<String> getRoles() {
        return new LinkedHashSet<String>(this.roles);
    }

    public void setRoles(Set<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles = roles;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.attributes);
        out.writeObject(this.authenticationAttributes);
        out.writeBoolean(this.isRemembered);
        out.writeObject(this.roles);
        out.writeObject(this.clientName);
        out.writeObject(this.linkedId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.attributes = (Map)in.readObject();
        this.authenticationAttributes = (Map)in.readObject();
        this.isRemembered = in.readBoolean();
        this.roles = (Set)in.readObject();
        this.clientName = (String)in.readObject();
        this.linkedId = (String)in.readObject();
    }

    public void removeLoginData() {
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public Principal asPrincipal() {
        return new Pac4JPrincipal(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicUserProfile)) {
            return false;
        }
        BasicUserProfile other = (BasicUserProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemembered != other.isRemembered) {
            return false;
        }
        if (this.canAttributesBeMerged != other.canAttributesBeMerged) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, Object> this$attributes = this.attributes;
        Map<String, Object> other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, Object> this$authenticationAttributes = this.authenticationAttributes;
        Map<String, Object> other$authenticationAttributes = other.authenticationAttributes;
        if (this$authenticationAttributes == null ? other$authenticationAttributes != null : !((Object)this$authenticationAttributes).equals(other$authenticationAttributes)) {
            return false;
        }
        Set<String> this$roles = this.roles;
        Set<String> other$roles = other.roles;
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$clientName = this.clientName;
        String other$clientName = other.clientName;
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$linkedId = this.linkedId;
        String other$linkedId = other.linkedId;
        return !(this$linkedId == null ? other$linkedId != null : !this$linkedId.equals(other$linkedId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicUserProfile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemembered ? 79 : 97);
        result = result * 59 + (this.canAttributesBeMerged ? 79 : 97);
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, Object> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, Object> $authenticationAttributes = this.authenticationAttributes;
        result = result * 59 + ($authenticationAttributes == null ? 43 : ((Object)$authenticationAttributes).hashCode());
        Set<String> $roles = this.roles;
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $clientName = this.clientName;
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $linkedId = this.linkedId;
        result = result * 59 + ($linkedId == null ? 43 : $linkedId.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "BasicUserProfile(logger=" + this.logger + ", id=" + this.id + ", attributes=" + this.attributes + ", authenticationAttributes=" + this.authenticationAttributes + ", isRemembered=" + this.isRemembered + ", roles=" + this.roles + ", clientName=" + this.clientName + ", linkedId=" + this.linkedId + ", canAttributesBeMerged=" + this.canAttributesBeMerged + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRemembered() {
        return this.isRemembered;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRemembered(boolean isRemembered) {
        this.isRemembered = isRemembered;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLinkedId() {
        return this.linkedId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLinkedId(String linkedId) {
        this.linkedId = linkedId;
    }
}

