/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;

public class DescribeAlarmsPublisher
implements SdkPublisher<DescribeAlarmsResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeAlarmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAlarmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAlarmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricAlarm> metricAlarms() {
        Function<DescribeAlarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricAlarms() != null) {
                return response.metricAlarms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAlarmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<CompositeAlarm> compositeAlarms() {
        Function<DescribeAlarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.compositeAlarms() != null) {
                return response.compositeAlarms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAlarmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAlarmsResponseFetcher
    implements AsyncPageFetcher<DescribeAlarmsResponse> {
        private DescribeAlarmsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAlarmsResponse> nextPage(DescribeAlarmsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmsPublisher.this.client.describeAlarms(DescribeAlarmsPublisher.this.firstRequest);
            }
            return DescribeAlarmsPublisher.this.client.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

