/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.surrogate.DefaultSurrogateCredentialParser;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialParser;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SurrogateWebflowConfigurer;
import org.apereo.cas.web.flow.action.LoadSurrogatesListAction;
import org.apereo.cas.web.flow.action.SurrogateAuthorizationAction;
import org.apereo.cas.web.flow.action.SurrogateInitialAuthenticationAction;
import org.apereo.cas.web.flow.action.SurrogateSelectionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
@Configuration(value="SurrogateAuthenticationWebflowConfiguration", proxyBeanMethods=false)
class SurrogateAuthenticationWebflowConfiguration {
    SurrogateAuthenticationWebflowConfiguration() {
    }

    @Configuration(value="SurrogateAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationWebflowPlanConfiguration {
        SurrogateAuthenticationWebflowPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"surrogateCasWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateCasWebflowExecutionPlanConfigurer(@Qualifier(value="surrogateWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer);
        }
    }

    @Configuration(value="SurrogateAuthenticationInitializerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationInitializerConfiguration {
        SurrogateAuthenticationInitializerConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public InitializingBean surrogateAuthenticationWebflowInitializer(@Qualifier(value="casWebflowExceptionCatalog") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return () -> handledAuthenticationExceptions.registerException(SurrogateAuthenticationException.class);
        }
    }

    @Configuration(value="SurrogateAuthenticationWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationWebflowActionConfiguration {
        SurrogateAuthenticationWebflowActionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"selectSurrogateAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action selectSurrogateAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="surrogatePrincipalBuilder") SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SurrogateSelectionAction(surrogatePrincipalBuilder)).withId("selectSurrogateAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateCredentialParser"})
        public SurrogateCredentialParser surrogateCredentialParser(CasConfigurationProperties casProperties) {
            return new DefaultSurrogateCredentialParser(casProperties.getAuthn().getSurrogate());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateInitialAuthenticationAction"})
        public Action surrogateInitialAuthenticationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="surrogateCredentialParser") SurrogateCredentialParser surrogateCredentialParser) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SurrogateInitialAuthenticationAction(surrogateCredentialParser)).withId("surrogateInitialAuthenticationAction").build().get();
        }

        @ConditionalOnMissingBean(name={"surrogateAuthorizationCheck"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action surrogateAuthorizationCheck(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SurrogateAuthorizationAction(registeredServiceAccessStrategyEnforcer)).withId("surrogateAuthorizationCheck").build().get();
        }

        @ConditionalOnMissingBean(name={"loadSurrogatesListAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action loadSurrogatesListAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="surrogatePrincipalBuilder") SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new LoadSurrogatesListAction(surrogateAuthenticationService, surrogatePrincipalBuilder)).withId("loadSurrogatesListAction").build().get();
        }
    }

    @Configuration(value="SurrogateAuthenticationWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationWebflowBaseConfiguration {
        SurrogateAuthenticationWebflowBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogateWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer surrogateWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new SurrogateWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }
    }
}

