/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationRequestTranslator;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OidcDefaultClientRegistrationRequestTranslator
implements OidcClientRegistrationRequestTranslator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultClientRegistrationRequestTranslator.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final int GENERATED_CLIENT_NAME_LENGTH = 8;
    private final ObjectProvider<OidcConfigurationContext> configurationContext;

    @Override
    public OidcRegisteredService translate(OidcClientRegistrationRequest registrationRequest, Optional<OidcRegisteredService> givenService) throws Exception {
        OidcConfigurationContext context = (OidcConfigurationContext)((Object)this.configurationContext.getObject());
        boolean containsFragment = registrationRequest.getRedirectUris().stream().anyMatch(uri -> uri.contains("#"));
        if (containsFragment) {
            throw new IllegalArgumentException("Redirect URI cannot contain a fragment");
        }
        ServicesManager servicesManager = context.getServicesManager();
        OidcRegisteredService registeredService = givenService.orElseGet(() -> registrationRequest.getRedirectUris().stream().map(uri -> (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByRedirectUri((ServicesManager)servicesManager, (String)uri)).filter(Objects::nonNull).findFirst().orElseGet(OidcRegisteredService::new));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getClientName())) {
            registeredService.setName(registrationRequest.getClientName());
        } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getName())) {
            registeredService.setName(RandomUtils.randomAlphabetic((int)8));
        }
        String serviceId = String.join((CharSequence)"|", registrationRequest.getRedirectUris());
        registeredService.setServiceId(serviceId);
        registeredService.setSectorIdentifierUri(registrationRequest.getSectorIdentifierUri());
        registeredService.setSubjectType(registrationRequest.getSubjectType());
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)OidcSubjectTypes.PAIRWISE.getType(), (CharSequence)registeredService.getSubjectType())) {
            registeredService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PairwiseOidcRegisteredServiceUsernameAttributeProvider());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getJwksUri())) {
            registeredService.setJwks(registrationRequest.getJwksUri());
        } else {
            JsonWebKeySet jwks = registrationRequest.getJwks();
            if (jwks != null && !jwks.getJsonWebKeys().isEmpty()) {
                jwks.getJsonWebKeys().stream().filter(key -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key.getKeyId())).forEach(key -> key.setKeyId(RandomUtils.randomAlphabetic((int)6)));
                registeredService.setJwks(jwks.toJson());
            }
        }
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getTokenEndpointAuthMethod(), __ -> registeredService.setTokenEndpointAuthenticationMethod(registrationRequest.getTokenEndpointAuthMethod()));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getClientId())) {
            registeredService.setClientId(context.getClientIdGenerator().getNewString());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getClientSecret())) {
            registeredService.setClientSecret(context.getClientSecretGenerator().getNewString());
        }
        registeredService.setEvaluationOrder(0);
        String urls = StringUtils.collectionToCommaDelimitedString(registrationRequest.getPostLogoutRedirectUris());
        registeredService.setLogoutUrl(urls);
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getLogo(), __ -> registeredService.setLogo(registrationRequest.getLogo()));
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getPolicyUri(), __ -> registeredService.setInformationUrl(registrationRequest.getPolicyUri()));
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getTermsOfUseUri(), __ -> registeredService.setPrivacyUrl(registrationRequest.getTermsOfUseUri()));
        OidcDefaultClientRegistrationRequestTranslator.processUserInfoSigningAndEncryption(registrationRequest, registeredService);
        this.processScopesAndResponsesAndGrants(registrationRequest, registeredService);
        if (!registrationRequest.getDefaultAcrValues().isEmpty()) {
            DefaultRegisteredServiceMultifactorPolicy multifactorPolicy = new DefaultRegisteredServiceMultifactorPolicy();
            multifactorPolicy.setMultifactorAuthenticationProviders(new HashSet<String>(registrationRequest.getDefaultAcrValues()));
            registeredService.setMultifactorAuthenticationPolicy((RegisteredServiceMultifactorPolicy)multifactorPolicy);
        }
        OidcDefaultClientRegistrationRequestTranslator.processIdTokenSigningAndEncryption(registrationRequest, registeredService);
        OidcDefaultClientRegistrationRequestTranslator.processIntrospectionSigningAndEncryption(registrationRequest, registeredService);
        OidcDefaultClientRegistrationRequestTranslator.processContacts(registrationRequest, registeredService);
        OidcDefaultClientRegistrationRequestTranslator.processTlsClientAuthentication(registrationRequest, registeredService);
        OidcDefaultClientRegistrationRequestTranslator.processClientSecretExpiration(context, registeredService);
        OidcDefaultClientRegistrationRequestTranslator.processClientBackchannelAuthentication(registrationRequest, registeredService);
        registeredService.setDescription("Registered service ".concat(registeredService.getName()));
        this.validate(registrationRequest, registeredService);
        return registeredService;
    }

    private static void processClientBackchannelAuthentication(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        registeredService.setBackchannelTokenDeliveryMode(registrationRequest.getBackchannelTokenDeliveryMode());
        registeredService.setBackchannelUserCodeParameterSupported(registrationRequest.isBackchannelUserCodeParameterSupported());
        registeredService.setBackchannelClientNotificationEndpoint(registrationRequest.getBackchannelClientNotificationEndpoint());
        registeredService.setBackchannelAuthenticationRequestSigningAlg(registrationRequest.getBackchannelAuthenticationRequestSigningAlg());
    }

    private static void processTlsClientAuthentication(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        FunctionUtils.doIfNotNull((Object)registrationRequest.getTlsClientAuthSanDns(), arg_0 -> ((OidcRegisteredService)registeredService).setTlsClientAuthSanDns(arg_0));
        FunctionUtils.doIfNotNull((Object)registrationRequest.getTlsClientAuthSanEmail(), arg_0 -> ((OidcRegisteredService)registeredService).setTlsClientAuthSanEmail(arg_0));
        FunctionUtils.doIfNotNull((Object)registrationRequest.getTlsClientAuthSanIp(), arg_0 -> ((OidcRegisteredService)registeredService).setTlsClientAuthSanIp(arg_0));
        FunctionUtils.doIfNotNull((Object)registrationRequest.getTlsClientAuthSanUri(), arg_0 -> ((OidcRegisteredService)registeredService).setTlsClientAuthSanUri(arg_0));
        FunctionUtils.doIfNotNull((Object)registrationRequest.getTlsClientAuthSubjectDn(), arg_0 -> ((OidcRegisteredService)registeredService).setTlsClientAuthSubjectDn(arg_0));
    }

    private void processScopesAndResponsesAndGrants(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        OidcConfigurationContext context = (OidcConfigurationContext)((Object)this.configurationContext.getObject());
        FunctionUtils.doIfNotNull(registrationRequest.getGrantTypes(), __ -> registeredService.setSupportedGrantTypes(new HashSet<String>(registrationRequest.getGrantTypes())));
        FunctionUtils.doIfNotNull(registrationRequest.getResponseTypes(), __ -> registeredService.setSupportedResponseTypes(new HashSet<String>(registrationRequest.getResponseTypes())));
        CasConfigurationProperties properties = context.getCasProperties();
        HashSet supportedScopes = new HashSet(properties.getAuthn().getOidc().getDiscovery().getScopes());
        registeredService.setScopes(supportedScopes);
        if (registeredService.getSupportedGrantTypes().isEmpty()) {
            registeredService.setSupportedGrantTypes(CollectionUtils.wrapHashSet((Object[])new String[]{OAuth20GrantTypes.AUTHORIZATION_CODE.getType()}));
        }
        if (registeredService.getSupportedResponseTypes().isEmpty()) {
            registeredService.setSupportedResponseTypes(CollectionUtils.wrapHashSet((Object[])new String[]{OAuth20ResponseTypes.CODE.getType()}));
        }
    }

    private static void processUserInfoSigningAndEncryption(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"none", (CharSequence)registrationRequest.getUserInfoSignedResponseAlg())) {
            registeredService.setUserInfoSigningAlg(registrationRequest.getUserInfoSignedResponseAlg());
        }
        registeredService.setUserInfoEncryptedResponseAlg(registrationRequest.getUserInfoEncryptedResponseAlg());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registeredService.getUserInfoEncryptedResponseAlg())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registrationRequest.getUserInfoEncryptedResponseEncoding())) {
                registeredService.setUserInfoEncryptedResponseEncoding("A128CBC-HS256");
            } else {
                registeredService.setUserInfoEncryptedResponseEncoding(registrationRequest.getUserInfoEncryptedResponseEncoding());
            }
        }
    }

    private static void processIntrospectionSigningAndEncryption(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getIntrospectionSignedResponseAlg(), __ -> registeredService.setIntrospectionSignedResponseAlg(registrationRequest.getIntrospectionSignedResponseAlg()));
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getIntrospectionEncryptedResponseAlg(), __ -> registeredService.setIntrospectionEncryptedResponseAlg(registrationRequest.getIntrospectionEncryptedResponseAlg()));
        FunctionUtils.doIfNotBlank((CharSequence)registrationRequest.getIntrospectionEncryptedResponseEncoding(), __ -> registeredService.setIntrospectionEncryptedResponseEncoding(registrationRequest.getIntrospectionEncryptedResponseEncoding()));
    }

    private static void processIdTokenSigningAndEncryption(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenSignedResponseAlg())) {
            registeredService.setIdTokenSigningAlg(registrationRequest.getIdTokenSignedResponseAlg());
            registeredService.setSignIdToken(true);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenEncryptedResponseAlg())) {
            registeredService.setIdTokenEncryptionAlg(registrationRequest.getIdTokenEncryptedResponseAlg());
            registeredService.setEncryptIdToken(true);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenEncryptedResponseEncoding())) {
            registeredService.setIdTokenEncryptionEncoding(registrationRequest.getIdTokenEncryptedResponseEncoding());
            registeredService.setEncryptIdToken(true);
        }
    }

    private static void processClientSecretExpiration(OidcConfigurationContext context, OidcRegisteredService registeredService) {
        long clientSecretExp = Beans.newDuration((String)context.getCasProperties().getAuthn().getOidc().getRegistration().getClientSecretExpiration()).toSeconds();
        if (clientSecretExp > 0L && registeredService.getClientSecretExpiration() <= 0L) {
            ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime expirationDate = currentTime.plusSeconds(clientSecretExp);
            LOGGER.debug("Client secret shall expire at [{}] while now is [{}]", (Object)expirationDate, (Object)currentTime);
            registeredService.setClientSecretExpiration(expirationDate.toEpochSecond());
        }
    }

    private static void processContacts(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) {
        registeredService.getContacts().clear();
        registrationRequest.getContacts().forEach(givenContact -> {
            DefaultRegisteredServiceContact contact = new DefaultRegisteredServiceContact();
            if (givenContact.contains("@")) {
                contact.setEmail(givenContact);
                contact.setName(givenContact.substring(0, givenContact.indexOf(64)));
            } else {
                contact.setName(givenContact);
            }
            registeredService.getContacts().add(contact);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) throws Exception {
        OidcProperties oidc;
        OidcConfigurationContext context = (OidcConfigurationContext)((Object)this.configurationContext.getObject());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registeredService.getSectorIdentifierUri())) {
            HttpResponse sectorResponse;
            block14: {
                sectorResponse = null;
                try {
                    HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(registeredService.getSectorIdentifierUri()).build();
                    sectorResponse = HttpUtils.execute((HttpExecutionRequest)exec);
                    if (sectorResponse == null || sectorResponse.getCode() != 200) break block14;
                    try (InputStream content = ((HttpEntityContainer)sectorResponse).getEntity().getContent();){
                        String result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
                        JavaType expectedType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{String.class});
                        Object urls = MAPPER.readValue(JsonValue.readHjson((String)result).toString(), expectedType);
                        if (!urls.equals(registrationRequest.getRedirectUris())) {
                            throw new IllegalArgumentException("Invalid sector identifier uri");
                        }
                    }
                }
                catch (Throwable throwable) {
                    HttpUtils.close(sectorResponse);
                    throw throwable;
                }
            }
            HttpUtils.close((HttpResponse)sectorResponse);
        }
        if (!(oidc = context.getCasProperties().getAuthn().getOidc()).getRegistration().getDynamicClientRegistrationMode().isProtected() && (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getPolicyUri()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getLogo()))) {
            String policy;
            String logo;
            List<String> hosts = registrationRequest.getRedirectUris().stream().map(uri -> (String)FunctionUtils.doUnchecked(() -> new URI((String)uri).getHost())).toList();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getLogo()) && !hosts.contains(logo = new URI(registrationRequest.getLogo()).getHost())) {
                throw new IllegalArgumentException("Invalid logo uri from an unknown host");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getPolicyUri()) && !hosts.contains(policy = new URI(registrationRequest.getPolicyUri()).getHost())) {
                throw new IllegalArgumentException("Invalid policy uri from an unknown host");
            }
        }
        if (org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)registeredService.getBackchannelTokenDeliveryMode(), (CharSequence[])new CharSequence[]{OidcBackchannelTokenDeliveryModes.PUSH.getMode(), OidcBackchannelTokenDeliveryModes.PING.getMode()})) {
            Assert.hasText((String)registeredService.getBackchannelClientNotificationEndpoint(), (String)"Backchannel client notification endpoint must be specified");
            Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.startsWith((CharSequence)registeredService.getBackchannelClientNotificationEndpoint(), (CharSequence)"https://"), (String)"Backchannel client notification endpoint MUST be an HTTPS url");
        }
    }

    @Generated
    public OidcDefaultClientRegistrationRequestTranslator(ObjectProvider<OidcConfigurationContext> configurationContext) {
        this.configurationContext = configurationContext;
    }
}

