/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hsql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.Binding;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.sql.DataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.plugin.HsqldbDataSourcePlugin;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.hsql.HsqlPrintWriter;
import org.apache.openejb.spi.ContainerSystem;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConfiguration;

public class HsqlService
implements ServerService,
SelfManaging {
    private static final String sc_key_port = "server.port";
    private static final String sc_key_silent = "server.silent";
    private static final String sc_key_dbname = "server.dbname";
    private static final String sc_key_address = "server.address";
    private static final String sc_key_database = "server.database";
    private static final String sc_key_no_system_exit = "server.no_system_exit";
    private static final String DRIVER_NAME = "HSQL Database Engine Driver";
    private int port = ServerConfiguration.getDefaultPort((int)1, (boolean)false);
    private String ip = "0.0.0.0";
    private Server server;

    public String getName() {
        return "hsql";
    }

    public int getPort() {
        return this.port;
    }

    public String getIP() {
        return this.ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties p) throws Exception {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String property = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (property.startsWith("server.dbname.") || property.startsWith("server.database.")) {
                throw new ServiceException("Databases cannot be declared in the hsql.properties.  Instead declare a database connection in the openejb.conf file");
            }
            if ("port".equals(property)) {
                properties.setProperty(sc_key_port, value);
                continue;
            }
            if ("bind".equals(property)) {
                properties.setProperty(sc_key_address, value);
                continue;
            }
            properties.setProperty(property, value);
        }
        properties.setProperty(sc_key_no_system_exit, "true");
        boolean disabled = Boolean.parseBoolean(properties.getProperty("disabled"));
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        if (!disabled && containerSystem != null) {
            try {
                NamingEnumeration<Binding> bindings = containerSystem.getJNDIContext().listBindings("openejb/Resource/");
                TreeSet<String> dbnames = new TreeSet<String>();
                for (Binding binding : Collections.list(bindings)) {
                    Object value = binding.getObject();
                    if (!(value instanceof DataSource)) continue;
                    DataSource jdbc = (DataSource)value;
                    Connection connection = null;
                    String path = null;
                    try {
                        connection = jdbc.getConnection();
                        DatabaseMetaData meta = connection.getMetaData();
                        path = this.getPath(meta.getDriverName(), meta.getURL());
                    }
                    catch (Throwable t) {}
                    continue;
                    finally {
                        if (connection == null) continue;
                        try {
                            connection.close();
                        }
                        catch (SQLException meta) {}
                        continue;
                    }
                    if (path == null) continue;
                    if (dbnames.size() > 9) {
                        throw new ServiceException("Hsql Server can only host 10 database instances");
                    }
                    String dbname = path.substring(path.lastIndexOf(58) + 1);
                    if (dbnames.contains(dbname = dbname.substring(dbname.lastIndexOf(47) + 1))) continue;
                    properties.put("server.dbname." + dbnames.size(), dbname);
                    properties.put("server.database." + dbnames.size(), path);
                    dbnames.add(dbname);
                }
            }
            catch (NameNotFoundException dbnames) {
                // empty catch block
            }
            this.server = new Server();
            properties.setProperty(sc_key_silent, "true");
            this.server.setLogWriter((PrintWriter)new HsqlPrintWriter(false));
            this.server.setErrWriter((PrintWriter)new HsqlPrintWriter(true));
            this.server.setProperties(new HsqlProperties(properties));
            this.port = this.server.getPort();
            String ipString = this.server.getAddress();
            if (ipString != null && ipString.length() > 0) {
                this.ip = ipString;
            }
        }
    }

    private String getPath(String driver, String url) {
        if (!"HSQL Database Engine".equals(driver) && !DRIVER_NAME.equals(driver)) {
            return null;
        }
        if (url == null || !url.startsWith("jdbc:hsqldb:")) {
            return null;
        }
        String path = HsqldbDataSourcePlugin.toAbsolutePath((String)url).substring("jdbc:hsqldb:".length());
        if (!path.startsWith("file:") && !path.startsWith("mem:") && path.startsWith("res:")) {
            return null;
        }
        return path;
    }

    public void service(InputStream inputStream, OutputStream outputStream) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(Socket socket)");
    }

    public void start() throws ServiceException {
        if (this.server == null) {
            return;
        }
        this.server.start();
    }

    public void stop() throws ServiceException {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        finally {
            this.server = null;
            DatabaseManager.closeDatabases((int)3);
        }
    }
}

