/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.SOAPClientException;
import org.opensaml.soap.client.SOAPFaultException;
import org.opensaml.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.soap.common.SOAPException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Deprecated
@ThreadSafe
public class HttpSOAPClient
extends AbstractInitializableComponent
implements SOAPClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpSOAPClient.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    private ParserPool parserPool;
    @Nonnull
    private Function<MessageContext, SOAPClientContext> soapClientContextLookupStrategy;
    @Nonnull
    private Function<MessageContext, SOAP11Context> soap11ContextLookupStrategy;

    public HttpSOAPClient() {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)"HttpSOAPClient", null, (String)"Pipeline-based SOAP client");
        this.soapClientContextLookupStrategy = new ChildContextLookup(SOAPClientContext.class);
        this.soap11ContextLookupStrategy = new ChildContextLookup(SOAP11Context.class);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
        if (this.parserPool == null) {
            throw new ComponentInitializationException("ParserPool cannot be null");
        }
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setParserPool(@Nonnull ParserPool parser) {
        this.checkSetterPreconditions();
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)parser, (String)"ParserPool cannot be null");
    }

    @Nonnull
    public Function<MessageContext, SOAPClientContext> getSOAPClientContextLookupStrategy() {
        return this.soapClientContextLookupStrategy;
    }

    public void setSOAPClientContextLookupStrategy(@Nonnull Function<MessageContext, SOAPClientContext> strategy) {
        this.checkSetterPreconditions();
        this.soapClientContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SOAP client context lookup strategy cannot be null");
    }

    @Nonnull
    public Function<MessageContext, SOAP11Context> getSOAP11ContextLookupStrategy() {
        return this.soap11ContextLookupStrategy;
    }

    public void setSOAP11ContextLookupStrategy(@Nonnull Function<MessageContext, SOAP11Context> strategy) {
        this.checkSetterPreconditions();
        this.soap11ContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SOAP 1.1 context lookup strategy cannot be null");
    }

    @Override
    public void send(@Nonnull @NotEmpty String endpoint, @Nonnull InOutOperationContext context) throws SOAPException, SecurityException {
        block12: {
            Envelope env;
            Constraint.isNotNull((Object)endpoint, (String)"Endpoint cannot be null");
            Constraint.isNotNull((Object)context, (String)"Operation context cannot be null");
            SOAP11Context soapCtx = this.soap11ContextLookupStrategy.apply(context.getOutboundMessageContext());
            SOAPClientContext clientCtx = this.soapClientContextLookupStrategy.apply(context.getOutboundMessageContext());
            HttpSOAPRequestParameters soapRequestParams = null;
            Envelope envelope = env = soapCtx != null ? soapCtx.getEnvelope() : null;
            if (env == null) {
                throw new SOAPClientException("Operation context did not contain an outbound SOAP Envelope");
            }
            if (clientCtx != null) {
                soapRequestParams = (HttpSOAPRequestParameters)clientCtx.getSOAPRequestParameters();
            }
            HttpPost post = this.createPostMethod(endpoint, soapRequestParams, env);
            try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)post, null);){
                int code = response.getCode();
                this.log.debug("Received HTTP status code of {} when POSTing SOAP message to {}", (Object)code, (Object)endpoint);
                if (code == 200) {
                    this.processSuccessfulResponse(response, context);
                    break block12;
                }
                if (code == 500) {
                    this.processFaultResponse(response, context);
                    break block12;
                }
                throw new SOAPClientException("Received " + code + " HTTP response status code from HTTP request to " + endpoint);
            }
            catch (IOException e) {
                throw new SOAPClientException("Unable to send request to " + endpoint, e);
            }
        }
    }

    protected HttpPost createPostMethod(@Nonnull @NotEmpty String endpoint, @Nullable HttpSOAPRequestParameters requestParams, @Nonnull Envelope message) throws SOAPClientException {
        this.log.debug("POSTing SOAP message to {}", (Object)endpoint);
        HttpPost post = new HttpPost(endpoint);
        post.setEntity(this.createRequestEntity(message, Charset.forName("UTF-8")));
        if (requestParams != null && requestParams.getSOAPAction() != null) {
            post.setHeader("SOAPAction", (Object)requestParams.getSOAPAction());
        }
        return post;
    }

    @Nonnull
    protected HttpEntity createRequestEntity(@Nonnull Envelope message, @Nullable Charset charset) throws SOAPClientException {
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().ensureMarshaller((XMLObject)message);
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Outbound SOAP message is:\n" + SerializeSupport.prettyPrintXML((Node)marshaller.marshall((XMLObject)message)));
            }
            SerializeSupport.writeNode((Node)marshaller.marshall((XMLObject)message), (OutputStream)arrayOut);
            return new ByteArrayEntity(arrayOut.toByteArray(), ContentType.TEXT_XML);
        }
        catch (MarshallingException e) {
            throw new SOAPClientException("Unable to marshall SOAP envelope", (Exception)((Object)e));
        }
    }

    protected void processSuccessfulResponse(@Nonnull ClassicHttpResponse httpResponse, @Nonnull InOutOperationContext context) throws SOAPClientException {
        try (HttpEntity entity = httpResponse.getEntity();){
            if (entity == null) {
                throw new SOAPClientException("No response body from server");
            }
            Envelope response = this.unmarshallResponse(entity.getContent());
            context.setInboundMessageContext(new MessageContext());
            ((SOAP11Context)context.ensureInboundMessageContext().ensureSubcontext(SOAP11Context.class)).setEnvelope(response);
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    protected void processFaultResponse(@Nonnull ClassicHttpResponse httpResponse, @Nonnull InOutOperationContext context) throws SOAPClientException, SOAPFaultException {
        try {
            HttpEntity entity = httpResponse.getEntity();
            try {
                if (entity == null) {
                    throw new SOAPClientException("No response body from server");
                }
                Envelope response = this.unmarshallResponse(entity.getContent());
                context.setInboundMessageContext(new MessageContext());
                ((SOAP11Context)context.ensureInboundMessageContext().ensureSubcontext(SOAP11Context.class)).setEnvelope(response);
                Body body = response.getBody();
                if (body != null) {
                    FaultString fstring;
                    QName fcodeval;
                    List faults = body.getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
                    if (faults.size() < 1) {
                        throw new SOAPClientException("HTTP status code was 500 but SOAP response did not contain a Fault");
                    }
                    String code = "(not set)";
                    String msg = "(not set)";
                    Fault fault = (Fault)faults.get(0);
                    FaultCode fcode = fault.getCode();
                    if (fcode != null && (fcodeval = fcode.getValue()) != null) {
                        code = fcodeval.toString();
                    }
                    if ((fstring = fault.getMessage()) != null && fstring.getValue() != null) {
                        msg = fstring.getValue();
                    }
                    this.log.debug("SOAP fault code {} with message {}", (Object)code, (Object)msg);
                    SOAPFaultException faultException = new SOAPFaultException("SOAP Fault: " + code + " Fault Message: " + msg);
                    faultException.setFault(fault);
                    throw faultException;
                }
                throw new SOAPClientException("HTTP status code was 500 but SOAP response did not contain a Body");
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    try {
                        entity.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    @Nonnull
    protected Envelope unmarshallResponse(@Nonnull InputStream responseStream) throws SOAPClientException {
        Envelope envelope;
        block11: {
            InputStream inputStream = responseStream;
            try {
                Element responseElem = this.parserPool.parse(responseStream).getDocumentElement();
                assert (responseElem != null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Inbound SOAP message was:\n" + SerializeSupport.prettyPrintXML((Node)responseElem));
                }
                Unmarshaller unmarshaller = (Unmarshaller)Constraint.isNotNull((Object)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(responseElem), (String)"SOAP envelope unmarshaller not available");
                envelope = (Envelope)unmarshaller.unmarshall(responseElem);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLParserException e) {
                    throw new SOAPClientException("Unable to parse the XML within the response", (Exception)e);
                }
                catch (UnmarshallingException e) {
                    throw new SOAPClientException("Unable to unmarshall the response DOM", (Exception)((Object)e));
                }
            }
            inputStream.close();
        }
        return envelope;
    }
}

