/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import java.util.Objects;
import javax.sql.CommonDataSource;

public class Key {
    private final CommonDataSource ds;
    private final String user;
    private final String pwd;
    private final int hash;

    public Key(CommonDataSource ds, String user, String pwd) {
        this.ds = ds;
        this.user = user;
        this.pwd = pwd;
        int result = ds.hashCode();
        result = 31 * result + (user != null ? user.hashCode() : 0);
        this.hash = result = 31 * result + (pwd != null ? pwd.hashCode() : 0);
    }

    public CommonDataSource getDs() {
        return this.ds;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)Key.class.cast(o);
        return (this.ds == key.ds || this.ds.equals(key.ds)) && Objects.equals(this.user, key.user) && Objects.equals(this.pwd, key.pwd);
    }

    public String toString() {
        return "Key{ds=" + String.valueOf(this.ds) + ", user='" + this.user + "', pwd='*****', hash=" + this.hash + "}";
    }

    public int hashCode() {
        return this.hash;
    }
}

