// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/cpp/data_type_limits.h"

namespace webnn {

DataTypeLimits::DataTypeLimits(mojo::DefaultConstruct::Tag) {}

DataTypeLimits::DataTypeLimits(SupportedDataTypes input,
                               SupportedDataTypes constant,
                               SupportedDataTypes arg_min_max_input,
                               SupportedDataTypes arg_min_max_output,
                               SupportedDataTypes batch_normalization_input,
                               SupportedDataTypes cast_input,
                               SupportedDataTypes clamp_input,
                               SupportedDataTypes concat_inputs,
                               SupportedDataTypes conv2d_input,
                               SupportedDataTypes conv_transpose2d_input,
                               SupportedDataTypes cumulative_sum_input,
                               SupportedDataTypes dequantize_linear_input,
                               SupportedDataTypes dequantize_linear_scale,
                               SupportedDataTypes add_input,
                               SupportedDataTypes sub_input,
                               SupportedDataTypes mul_input,
                               SupportedDataTypes div_input,
                               SupportedDataTypes max_input,
                               SupportedDataTypes min_input,
                               SupportedDataTypes pow_input,
                               SupportedDataTypes equal_input,
                               SupportedDataTypes greater_input,
                               SupportedDataTypes greater_or_equal_input,
                               SupportedDataTypes lesser_input,
                               SupportedDataTypes lesser_or_equal_input,
                               SupportedDataTypes logical_not_input,
                               SupportedDataTypes logical_output,
                               SupportedDataTypes abs_input,
                               SupportedDataTypes ceil_input,
                               SupportedDataTypes cos_input,
                               SupportedDataTypes erf_input,
                               SupportedDataTypes exp_input,
                               SupportedDataTypes floor_input,
                               SupportedDataTypes identity_input,
                               SupportedDataTypes log_input,
                               SupportedDataTypes neg_input,
                               SupportedDataTypes reciprocal_input,
                               SupportedDataTypes sign_input,
                               SupportedDataTypes sin_input,
                               SupportedDataTypes sqrt_input,
                               SupportedDataTypes tan_input,
                               SupportedDataTypes elu_input,
                               SupportedDataTypes expand_input,
                               SupportedDataTypes gather_input,
                               SupportedDataTypes gather_indices,
                               SupportedDataTypes gather_elements_input,
                               SupportedDataTypes gather_elements_indices,
                               SupportedDataTypes gelu_input,
                               SupportedDataTypes gemm_input,
                               SupportedDataTypes gru_input,
                               SupportedDataTypes gru_cell_input,
                               SupportedDataTypes hard_sigmoid_input,
                               SupportedDataTypes hard_swish_input,
                               SupportedDataTypes instance_normalization_input,
                               SupportedDataTypes layer_normalization_input,
                               SupportedDataTypes leaky_relu_input,
                               SupportedDataTypes linear_input,
                               SupportedDataTypes lstm_input,
                               SupportedDataTypes lstm_cell_input,
                               SupportedDataTypes matmul_input,
                               SupportedDataTypes pad_input,
                               SupportedDataTypes average_pool2d_input,
                               SupportedDataTypes l2_pool2d_input,
                               SupportedDataTypes max_pool2d_input,
                               SupportedDataTypes prelu_input,
                               SupportedDataTypes quantize_linear_input,
                               SupportedDataTypes quantize_linear_zero_point,
                               SupportedDataTypes reduce_l1_input,
                               SupportedDataTypes reduce_l2_input,
                               SupportedDataTypes reduce_log_sum_input,
                               SupportedDataTypes reduce_log_sum_exp_input,
                               SupportedDataTypes reduce_max_input,
                               SupportedDataTypes reduce_mean_input,
                               SupportedDataTypes reduce_min_input,
                               SupportedDataTypes reduce_product_input,
                               SupportedDataTypes reduce_sum_input,
                               SupportedDataTypes reduce_sum_square_input,
                               SupportedDataTypes relu_input,
                               SupportedDataTypes resample2d_input,
                               SupportedDataTypes reshape_input,
                               SupportedDataTypes scatter_nd_input,
                               SupportedDataTypes scatter_nd_indices,
                               SupportedDataTypes sigmoid_input,
                               SupportedDataTypes slice_input,
                               SupportedDataTypes softmax_input,
                               SupportedDataTypes softplus_input,
                               SupportedDataTypes softsign_input,
                               SupportedDataTypes split_input,
                               SupportedDataTypes tanh_input,
                               SupportedDataTypes tile_input,
                               SupportedDataTypes transpose_input,
                               SupportedDataTypes triangular_input,
                               SupportedDataTypes where_condition,
                               SupportedDataTypes where_value)
    : input(input),
      constant(constant),
      arg_min_max_input(arg_min_max_input),
      arg_min_max_output(arg_min_max_output),
      batch_normalization_input(batch_normalization_input),
      cast_input(cast_input),
      clamp_input(clamp_input),
      concat_inputs(concat_inputs),
      conv2d_input(conv2d_input),
      conv_transpose2d_input(conv_transpose2d_input),
      cumulative_sum_input(cumulative_sum_input),
      dequantize_linear_input(dequantize_linear_input),
      dequantize_linear_scale(dequantize_linear_scale),
      add_input(add_input),
      sub_input(sub_input),
      mul_input(mul_input),
      div_input(div_input),
      max_input(max_input),
      min_input(min_input),
      pow_input(pow_input),
      equal_input(equal_input),
      greater_input(greater_input),
      greater_or_equal_input(greater_or_equal_input),
      lesser_input(lesser_input),
      lesser_or_equal_input(lesser_or_equal_input),
      logical_not_input(logical_not_input),
      logical_output(logical_output),
      abs_input(abs_input),
      ceil_input(ceil_input),
      cos_input(cos_input),
      erf_input(erf_input),
      exp_input(exp_input),
      floor_input(floor_input),
      identity_input(identity_input),
      log_input(log_input),
      neg_input(neg_input),
      reciprocal_input(reciprocal_input),
      sign_input(sign_input),
      sin_input(sin_input),
      sqrt_input(sqrt_input),
      tan_input(tan_input),
      elu_input(elu_input),
      expand_input(expand_input),
      gather_input(gather_input),
      gather_indices(gather_indices),
      gather_elements_input(gather_elements_input),
      gather_elements_indices(gather_elements_indices),
      gelu_input(gelu_input),
      gemm_input(gemm_input),
      gru_input(gru_input),
      gru_cell_input(gru_cell_input),
      hard_sigmoid_input(hard_sigmoid_input),
      hard_swish_input(hard_swish_input),
      instance_normalization_input(instance_normalization_input),
      layer_normalization_input(layer_normalization_input),
      leaky_relu_input(leaky_relu_input),
      linear_input(linear_input),
      lstm_input(lstm_input),
      lstm_cell_input(lstm_cell_input),
      matmul_input(matmul_input),
      pad_input(pad_input),
      average_pool2d_input(average_pool2d_input),
      l2_pool2d_input(l2_pool2d_input),
      max_pool2d_input(max_pool2d_input),
      prelu_input(prelu_input),
      quantize_linear_input(quantize_linear_input),
      quantize_linear_zero_point(quantize_linear_zero_point),
      reduce_l1_input(reduce_l1_input),
      reduce_l2_input(reduce_l2_input),
      reduce_log_sum_input(reduce_log_sum_input),
      reduce_log_sum_exp_input(reduce_log_sum_exp_input),
      reduce_max_input(reduce_max_input),
      reduce_mean_input(reduce_mean_input),
      reduce_min_input(reduce_min_input),
      reduce_product_input(reduce_product_input),
      reduce_sum_input(reduce_sum_input),
      reduce_sum_square_input(reduce_sum_square_input),
      relu_input(relu_input),
      resample2d_input(resample2d_input),
      reshape_input(reshape_input),
      scatter_nd_input(scatter_nd_input),
      scatter_nd_indices(scatter_nd_indices),
      sigmoid_input(sigmoid_input),
      slice_input(slice_input),
      softmax_input(softmax_input),
      softplus_input(softplus_input),
      softsign_input(softsign_input),
      split_input(split_input),
      tanh_input(tanh_input),
      tile_input(tile_input),
      transpose_input(transpose_input),
      triangular_input(triangular_input),
      where_condition(where_condition),
      where_value(where_value) {}

DataTypeLimits::DataTypeLimits(const DataTypeLimits&) = default;
DataTypeLimits& DataTypeLimits::operator=(const DataTypeLimits&) = default;
DataTypeLimits::DataTypeLimits(DataTypeLimits&&) noexcept = default;
DataTypeLimits& DataTypeLimits::operator=(DataTypeLimits&&) noexcept = default;

DataTypeLimits::~DataTypeLimits() = default;

}  // namespace webnn
